""" Configuration file for the Sphinx documentation builder.

This file only contains a selection of the most common options. For a full
list see the documentation:
https://www.sphinx-doc.org/en/master/usage/configuration.html
"""

# -- Path setup --------------------------------------------------------------

import datetime
import os
import sys

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
sys.path.insert(0, os.path.abspath("../.."))

# Allow reading Django files/syntax, in order to generate docs from them.
import django  # pylint:disable=wrong-import-position
from django.conf import settings  # pylint:disable=wrong-import-position
from django_dump_die import __version__  # pylint:disable=wrong-import-position,import-error

# -- Project information -----------------------------------------------------
AUTHORS = "David Barnes, Brandon Rodriguez"
project = "Django-Dump-Die"  # pylint:disable=invalid-name
copyright = f"{datetime.date.today().year}, {AUTHORS}"  # pylint:disable=invalid-name,redefined-builtin
author = "David Barnes, Brandon Rodriguez"  # pylint:disable=invalid-name

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = __version__
# The full version, including alpha/beta/rc tags.
release = __version__


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.doctest",
    "sphinx.ext.intersphinx",
    "sphinx.ext.autosummary",
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = "sphinx_rtd_theme"  # pylint:disable=invalid-name

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = []


# -- Django Configuration ----------------------------------------------------
settings.configure(
    SECRET_KEY="something-to-make-Django-happy",
    INSTALLED_APPS=[
        "django_dump_die",
        "django.contrib.admin",
        "django.contrib.auth",
        "django.contrib.contenttypes",
    ],
)
django.setup()
