"""
Date: 11-22-19
Class: CS5310
Assignment: Linear Programming Simplex Algorithm
Author: Brandon Rodriguez


Tests for "Simplex" function implementation of the Simplex algorithm.
"""

# System Imports.
import unittest

# User Class Imports.
from resources.simplex.base import SimplexBase


class TestPivot(unittest.TestCase):
    def setUp(self):
        self.simplex = SimplexBase()

    def test__run_simplex(self):
        # Setup initial simplex, using JSON data.
        self.simplex.read_data_from_json('./resources/json_files/ex_1.json')

        # Test initial values after setup.
        self.assertEqual(self.simplex._matrix_a, [
            [1, 1, 1, 0],
            [1, 1, 0, 1]
        ])
        self.assertEqual(self.simplex._vector_b, [1, 1])
        self.assertEqual(self.simplex._vector_c, [1, 1, 0, 0, 0])
        self.assertEqual(self.simplex._obj_constant_index, 4)
        self.assertEqual(self.simplex._b_array, [2, 3])
        self.assertEqual(self.simplex._n_array, [0, 1])

        # Attempt to fully solve simplex.
        self.simplex.display_tableau()
        results = self.simplex.solve()

        # Test values after solving.
        self.assertEqual(results[0], 1)
        self.assertEqual(results[1], (1, 0))
