"""
Date: 11-22-19
Class: CS5310
Assignment: Linear Programming Simplex Algorithm
Author: Brandon Rodriguez


Tests for "Pivot" function implementation of the Simplex algorithm.
"""

# System Imports.
import unittest

# User Class Imports.
from resources.simplex.base import SimplexBase


class TestPivot(unittest.TestCase):
    def setUp(self):
        self.simplex = SimplexBase()

    def test__pivot(self):
        # Setup initial simplex.
        self.simplex.set_simplex_values(
            [
                [1, 1, 1],
                [2, -1, 2],
                [2, 1, 0],
            ],
            [5, 3, 4],
            [2, 4, 1],
        )

        # Test initial values after setup.
        self.assertEqual(self.simplex._matrix_a, [
            [1, 1, 1, 1, 0, 0],
            [2, -1, 2, 0, 1, 0],
            [2, 1, 0, 0, 0, 1],
        ])
        self.assertEqual(self.simplex._vector_b, [5, 3, 4])
        self.assertEqual(self.simplex._vector_c, [2, 4, 1, 0, 0, 0, 0])
        self.assertEqual(self.simplex._obj_constant_index, 6)
        self.assertEqual(self.simplex._b_array, [3, 4, 5])
        self.assertEqual(self.simplex._n_array, [0, 1, 2])

        # Pivot once, switching col x6 for col x2.
        self.simplex.pivot(5, 1)

        # Test values after pivot.
        self.assertEqual(self.simplex._matrix_a, [
            [-1, 0, 1, 1, 0, -1],
            [4, 0, 2, 0, 1, 1],
            [2, 1, 0, 0, 0, 1],
        ])
        self.assertEqual(self.simplex._vector_b, [1, 7, 4])
        self.assertEqual(self.simplex._vector_c, [-6, 0, 1, 0, 0, -4, -16])
        self.assertEqual(self.simplex._obj_constant_index, 6)
        self.assertEqual(self.simplex._b_array, [3, 4, 1])
        self.assertEqual(self.simplex._n_array, [0, 2, 5])
