"""
Date: 11-22-19
Class: CS5310
Assignment: Linear Programming Simplex Algorithm
Author: Brandon Rodriguez


Tests for "Initialize" function implementation of the Simplex algorithm.
"""

# System Imports.
import unittest

# User Class Imports.
from resources.simplex.base import SimplexBase


class TestInitialize(unittest.TestCase):
    def setUp(self):
        self.simplex = SimplexBase()

    def test__initialize(self):
        # Setup initial simplex.
        self.simplex.set_simplex_values(
            [
                [2, -1],
                [1, -5],
            ],
            [2, -4],
            [2, -1],
        )
        # Test initial values after setup.
        self.assertEqual(self.simplex._matrix_a, [
            [2, -1, 1, 0],
            [1, -5, 0, 1],
        ])
        self.assertEqual(self.simplex._vector_b, [2, -4])
        self.assertEqual(self.simplex._vector_c, [2, -1, 0, 0, 0])
        self.assertEqual(self.simplex._obj_constant_index, 4)
        self.assertEqual(self.simplex._b_array, [2, 3])
        self.assertEqual(self.simplex._n_array, [0, 1])

        # Call initialize method to test.
        # self.simplex.display_tableau()
        self.simplex.initialize()

        # self.simplex.display_tableau()

        # # Test initial values "initialize" method.
        # self.assertEqual(self.simplex._matrix_a, [
        #     [1-5, 1, 0, 1/5],
        #     [-9/5, 0, 1, 1/5],
        # ])
        # self.assertEqual(self.simplex._constants, [4/5, 14/5])
        # self.assertEqual(self.simplex._obj_func, [9/5, 0, 0, 1/5, -4/5])
        # self.assertEqual(self.simplex._obj_constant_index, 4)
        # self.assertEqual(self.simplex._basic_var_indexes, [1, 2])
        # self.assertEqual(self.simplex._nonbasic_var_indexes, [0, 3])
