"""
Date: 11-22-19
Class: CS5310
Assignment: Linear Programming Simplex Algorithm
Author: Brandon Rodriguez


Tests for base logic of the "Simplex" algorithm.
"""

# System Imports.
import unittest

# User Class Imports.
from resources.simplex.base import SimplexBase


class TestSimplex(unittest.TestCase):
    def setUp(self):
        self.simplex = SimplexBase()

    def test__parse_from_json__success(self):
        with self.subTest('Using first set of keys.'):
            self.simplex._parse_json_data({
                'constraints': [
                    [1],
                ],
                'constants': [2],
                'objective': [3],
                'basic_vars': [4],
                'non_basic_vars': [5],
            })
            self.assertEqual(self.simplex._matrix_a, [[1]])
            self.assertEqual(self.simplex._vector_b, [2])
            self.assertEqual(self.simplex._vector_c, [3, 0])
            self.assertEqual(self.simplex._obj_constant_index, 1)
            self.assertEqual(self.simplex._b_array, [4])
            self.assertEqual(self.simplex._n_array, [5])

        with self.subTest('Using second set of keys.'):
            self.simplex._parse_json_data({
                'constraint_matrix': [
                    [1],
                ],
                'constraint_constants': [2],
                'objective_function': [3],
                'basic_variables': [4],
                'non_basic_variables': [5],
            })
            self.assertEqual(self.simplex._matrix_a, [[1]])
            self.assertEqual(self.simplex._vector_b, [2])
            self.assertEqual(self.simplex._vector_c, [3, 0])
            self.assertEqual(self.simplex._obj_constant_index, 1)
            self.assertEqual(self.simplex._b_array, [4])
            self.assertEqual(self.simplex._n_array, [5])

        with self.subTest('Objective constant provided.'):
            self.simplex._parse_json_data({
                'constraint_matrix': [
                    [1],
                ],
                'constraint_constants': [2],
                'objective_function': [3, 5],
                'basic_variables': [4],
                'non_basic_variables': [5],
            })
            self.assertEqual(self.simplex._matrix_a, [[1]])
            self.assertEqual(self.simplex._vector_b, [2])
            self.assertEqual(self.simplex._vector_c, [3, 5])
            self.assertEqual(self.simplex._obj_constant_index, 1)
            self.assertEqual(self.simplex._b_array, [4])
            self.assertEqual(self.simplex._n_array, [5])


    def test__parse_from_json__failure(self):
        with self.subTest('No valid keys.'):
            with self.assertRaises(KeyError):
                self.simplex._parse_json_data({})

        with self.subTest('Only "constants" key.'):
            with self.assertRaises(KeyError):
                self.simplex._parse_json_data({
                    'constraints': [],
                })

        with self.subTest('No "objective" key.'):
            with self.assertRaises(KeyError):
                self.simplex._parse_json_data({
                    'constraints': [],
                    'constants': [],
                })

        with self.subTest('Key "constraints" is not list.'):
            with self.assertRaises(TypeError):
                self.simplex._parse_json_data({
                    'constraints': '',
                    'constants': [],
                    'objective': [],
                })

        with self.subTest('Key "constants" is not list.'):
            with self.assertRaises(TypeError):
                self.simplex._parse_json_data({
                    'constraints': [],
                    'constants': '',
                    'objective': [],
                })

        with self.subTest('Key "objective" is not list.'):
            with self.assertRaises(TypeError):
                self.simplex._parse_json_data({
                    'constraints': [],
                    'constants': [],
                    'objective': '',
                })

        with self.subTest('Key "constraints" is empty list.'):
            with self.assertRaises(ValueError):
                self.simplex._parse_json_data({
                    'constraints': [],
                    'constants': [1],
                    'objective': [1],
                })

        with self.subTest('Key "constants" is empty list.'):
            with self.assertRaises(ValueError):
                self.simplex._parse_json_data({
                    'constraints': [1],
                    'constants': [],
                    'objective': [1],
                })

        with self.subTest('Key "objective" is empty list.'):
            with self.assertRaises(ValueError):
                self.simplex._parse_json_data({
                    'constraints': [1],
                    'constants': [1],
                    'objective': [],
                })

        with self.subTest('Constraint matrix is not list of lists.'):
            with self.assertRaises(TypeError):
                self.simplex._parse_json_data({
                    'constraints': [1],
                    'constants': [1],
                    'objective': [1],
                })

        with self.subTest('Constraint matrix rows do not match up.'):
            with self.assertRaises(ValueError):
                self.simplex._parse_json_data({
                    'constraints': [
                        [1],
                        [1,2],
                    ],
                    'constants': [1],
                    'objective': [1],
                })

        with self.subTest('Constraint matrix and constraint constants do not match up.'):
            with self.assertRaises(ValueError):
                self.simplex._parse_json_data({
                    'constraints': [
                        [1],
                        [1],
                    ],
                    'constants': [1],
                    'objective': [1],
                })

        with self.subTest('Objective function less than length of constraint matrix rows.'):
            with self.assertRaises(ValueError):
                self.simplex._parse_json_data({
                    'constraints': [
                        [1, 2],
                        [1, 2],
                    ],
                    'constants': [1, 1],
                    'objective': [1],
                })

        with self.subTest('Objective function greater than length of constraint matrix rows.'):
            with self.assertRaises(ValueError):
                self.simplex._parse_json_data({
                    'constraints': [
                        [1],
                        [1],
                    ],
                    'constants': [1, 1],
                    'objective': [1, 2, 3],
                })

        with self.subTest('Variable "basic_vars" is provided, but not list.'):
            with self.assertRaises(TypeError):
                self.simplex._parse_json_data({
                    'constraints': [
                        [1],
                        [1],
                    ],
                    'constants': [1, 1],
                    'objective': [1],
                    'basic_vars': '',
                })

        with self.subTest('Variable "non_basic_vars" is provided, but not list.'):
            with self.assertRaises(TypeError):
                self.simplex._parse_json_data({
                    'constraints': [
                        [1],
                        [1],
                    ],
                    'constants': [1, 1],
                    'objective': [1],
                    'non_basic_vars': '',
                })

    def test__set_simplex_values(self):
        # Note that type validation is already partially tested in above "parse_from_json" tests.
        # Thus, here we more specifically test logic for setting and accessing of basic/nonbasic variables.
        with self.subTest('No basic vars provided.'):
            self.simplex.set_simplex_values([
                    [1, 1, 1],
                    [1, 1, 1],
                    [1, 1, 1],
                ],
                [1, 1, 1],
                [1, 1, 1],
            )
            self.assertEqual(self.simplex._matrix_a, [
                [1, 1, 1, 1, 0, 0],
                [1, 1, 1, 0, 1, 0],
                [1, 1, 1, 0, 0, 1],
            ])
            self.assertEqual(self.simplex._vector_b, [1, 1, 1])
            self.assertEqual(self.simplex._vector_c, [1, 1, 1, 0, 0, 0, 0])
            self.assertEqual(self.simplex._obj_constant_index, 6)
            self.assertEqual(self.simplex._b_array, [3, 4, 5])
            self.assertEqual(self.simplex._n_array, [0, 1, 2])

        with self.subTest('Some basic vars implicitly provided.'):
            self.simplex.set_simplex_values([
                [1, 0, 1, 0, 1],
                [1, 1, 1, 0, 1],
                [1, 0, 1, 1, 1],
            ],
                [1, 1, 1],
                [1, 0, 1, 0, 1],
            )
            self.assertEqual(self.simplex._matrix_a, [
                [1, 0, 1, 0, 1, 1],
                [1, 1, 1, 0, 1, 0],
                [1, 0, 1, 1, 1, 0],
            ])
            self.assertEqual(self.simplex._vector_b, [1, 1, 1])
            self.assertEqual(self.simplex._vector_c, [1, 0, 1, 0, 1, 0, 0])
            self.assertEqual(self.simplex._obj_constant_index, 6)
            self.assertEqual(self.simplex._b_array, [1, 3, 5])
            self.assertEqual(self.simplex._n_array, [0, 2, 4])

        with self.subTest('Some basic vars implicitly provided - With obj constant.'):
            self.simplex.set_simplex_values([
                [1, 0, 1, 0, 1],
                [1, 1, 1, 0, 1],
                [1, 0, 1, 1, 1],
            ],
                [1, 1, 1],
                [1, 0, 1, 0, 1, 5],
            )
            self.assertEqual(self.simplex._matrix_a, [
                [1, 0, 1, 0, 1, 1],
                [1, 1, 1, 0, 1, 0],
                [1, 0, 1, 1, 1, 0],
            ])
            self.assertEqual(self.simplex._vector_b, [1, 1, 1])
            self.assertEqual(self.simplex._vector_c, [1, 0, 1, 0, 1, 0, 5])
            self.assertEqual(self.simplex._obj_constant_index, 6)
            self.assertEqual(self.simplex._b_array, [1, 3, 5])
            self.assertEqual(self.simplex._n_array, [0, 2, 4])

        with self.subTest('All basic vars implicitly provided at start.'):
            self.simplex.set_simplex_values([
                [0, 1, 0, 1, 1, 1],
                [1, 0, 0, 1, 1, 1],
                [0, 0, 1, 1, 1, 1],
            ],
                [1, 1, 1],
                [0, 0, 0, 1, 1, 1],
            )
            self.assertEqual(self.simplex._matrix_a, [
                [0, 1, 0, 1, 1, 1],
                [1, 0, 0, 1, 1, 1],
                [0, 0, 1, 1, 1, 1],
            ])
            self.assertEqual(self.simplex._vector_b, [1, 1, 1])
            self.assertEqual(self.simplex._vector_c, [0, 0, 0, 1, 1, 1, 0])
            self.assertEqual(self.simplex._obj_constant_index, 6)
            self.assertEqual(self.simplex._b_array, [0, 1, 2])
            self.assertEqual(self.simplex._n_array, [3, 4, 5])

        with self.subTest('All basic vars implicitly provided at start - With obj constant.'):
            self.simplex.set_simplex_values([
                [0, 1, 0, 1, 1, 1],
                [1, 0, 0, 1, 1, 1],
                [0, 0, 1, 1, 1, 1],
            ],
                [1, 1, 1],
                [0, 0, 0, 1, 1, 1, 5],
            )
            self.assertEqual(self.simplex._matrix_a, [
                [0, 1, 0, 1, 1, 1],
                [1, 0, 0, 1, 1, 1],
                [0, 0, 1, 1, 1, 1],
            ])
            self.assertEqual(self.simplex._vector_b, [1, 1, 1])
            self.assertEqual(self.simplex._vector_c, [0, 0, 0, 1, 1, 1, 5])
            self.assertEqual(self.simplex._obj_constant_index, 6)
            self.assertEqual(self.simplex._b_array, [0, 1, 2])
            self.assertEqual(self.simplex._n_array, [3, 4, 5])

        with self.subTest('All basic vars implicitly provided at end.'):
            self.simplex.set_simplex_values([
                [1, 1, 1, 0, 1, 0],
                [1, 1, 1, 0, 0, 1],
                [1, 1, 1, 1, 0, 0],
            ],
                [1, 1, 1],
                [1, 1, 1, 0, 0, 0],
            )
            self.assertEqual(self.simplex._matrix_a, [
                [1, 1, 1, 0, 1, 0],
                [1, 1, 1, 0, 0, 1],
                [1, 1, 1, 1, 0, 0],
            ])
            self.assertEqual(self.simplex._vector_b, [1, 1, 1])
            self.assertEqual(self.simplex._vector_c, [1, 1, 1, 0, 0, 0, 0])
            self.assertEqual(self.simplex._obj_constant_index, 6)
            self.assertEqual(self.simplex._b_array, [3, 4, 5])
            self.assertEqual(self.simplex._n_array, [0, 1, 2])

        with self.subTest('All basic vars implicitly provided at end - With objective constant.'):
            self.simplex.set_simplex_values([
                [1, 1, 1, 0, 1, 0],
                [1, 1, 1, 0, 0, 1],
                [1, 1, 1, 1, 0, 0],
            ],
                [1, 1, 1],
                [1, 1, 1, 0, 0, 0, 5],
            )
            self.assertEqual(self.simplex._matrix_a, [
                [1, 1, 1, 0, 1, 0],
                [1, 1, 1, 0, 0, 1],
                [1, 1, 1, 1, 0, 0],
            ])
            self.assertEqual(self.simplex._vector_b, [1, 1, 1])
            self.assertEqual(self.simplex._vector_c, [1, 1, 1, 0, 0, 0, 5])
            self.assertEqual(self.simplex._obj_constant_index, 6)
            self.assertEqual(self.simplex._b_array, [3, 4, 5])
            self.assertEqual(self.simplex._n_array, [0, 1, 2])

        with self.subTest('All basic vars explicitly provided at start.'):
            self.simplex.set_simplex_values([
                [0, 1, 0, 1, 1, 1],
                [1, 0, 0, 1, 1, 1],
                [0, 0, 1, 1, 1, 1],
            ],
                [1, 1, 1],
                [0, 0, 0, 1, 1, 1],
                basic_vars=[0, 1, 2],
            )
            self.assertEqual(self.simplex._matrix_a, [
                [0, 1, 0, 1, 1, 1],
                [1, 0, 0, 1, 1, 1],
                [0, 0, 1, 1, 1, 1],
            ])
            self.assertEqual(self.simplex._vector_b, [1, 1, 1])
            self.assertEqual(self.simplex._vector_c, [0, 0, 0, 1, 1, 1, 0])
            self.assertEqual(self.simplex._obj_constant_index, 6)
            self.assertEqual(self.simplex._b_array, [0, 1, 2])
            self.assertEqual(self.simplex._n_array, [3, 4, 5])

        with self.subTest('All basic vars explicitly provided at end.'):
            self.simplex.set_simplex_values([
                [1, 1, 1, 0, 1, 0],
                [1, 1, 1, 0, 0, 1],
                [1, 1, 1, 1, 0, 0],
            ],
                [1, 1, 1],
                [1, 1, 1, 0, 0, 0],
                basic_vars=[3, 4, 5],
            )
            self.assertEqual(self.simplex._matrix_a, [
                [1, 1, 1, 0, 1, 0],
                [1, 1, 1, 0, 0, 1],
                [1, 1, 1, 1, 0, 0],
            ])
            self.assertEqual(self.simplex._vector_b, [1, 1, 1])
            self.assertEqual(self.simplex._vector_c, [1, 1, 1, 0, 0, 0, 0])
            self.assertEqual(self.simplex._obj_constant_index, 6)
            self.assertEqual(self.simplex._b_array, [3, 4, 5])
            self.assertEqual(self.simplex._n_array, [0, 1, 2])
