# Peterson's Algorithm > Documents > Testing.md


## Description
General information to run both UnitTests and Pytests, with Python.
Includes information for both running through terminal and through Pycharm.

> Note: This has been tested on Linux (Ubuntu 16.04). May not work with Windows/Mac.


## Testing with UnitTest
Unittests come built into python. No need for third party packages.

### Running a Single UnitTest
The following will run tests from a single file.

> NOTE: For the file path of these two commands, replace any `/` characters with `.` instead.<br>
> So for example, `tests/my_tests/test_file.py` would turn into `tests.my_tests.test_file.py`.

* Terminal: From a terminal, run `python -m unittest <path_to_file>`

* Pycharm: Create a new `unittest` configuration with the properties:
    * Target: `custom`
    * Additional Arguments: `python -m unittest <path_to_file>`
    * Python Interpreter: `<your_preferred_interpreter_environment>`
    * Working Directory: `<project_root>`


### Running Multiple UnitTests
The following will "run all tests in a given directory".

> NOTE: For these to work as intended, there needs to be an "__init__.py" file in each project subdirectory that the
> tests access (even despite using Python3).

* Terminal: From a terminal at the project root, run `python -m unittest discover <path_to_folder> -p "*.py" -t ./`

* Pycharm: Create a new `unittest` configuration with the properties:
    * Target: `custom`
    * Additional Arguments: `discover -s <path_to_folder> -p "*.py" -t ./`
    * Python Interpreter: `<your_preferred_interpreter_environment>`
    * Working Directory: `<project_root>`

## PyTest
PyTest is an alternative to UnitTests, using a third party library.
To install, run `pip install pytest`.

### Running a Single PyTest
The following will run all tests from a single file.

* Terminal: From a terminal, run `pytest -q <path_to_file>`.

* Pycharm: Create a new `py.test` or `pytest` configuration (depending on your Pycharm version) with the properties:
    * Target: `custom`
    * Additional Arguments: `-q <path_to_file>`
    * Python Interpreter: `<your_preferred_interpreter_environment>`
    * Working Directory: `<project_root>`

### Running Multiple PyTests
The following will "run all tests in root folder".

> NOTE: You cannot have an `__init__.py` at project root.<br>
> If you get a ModuleError/ImportError, you also may have to create a blank `conftest.py` at project root.

* Terminal: From a terminal at the project root, run `pytest`.

* Pycharm: Create a new `py.test` or `pytest` configuration (depending on your Pycharm version) with the properties:
    * Target: `custom`
    * Python Interpreter: `<your_preferred_interpreter_environment>`
    * Working Directory: `<project_root>`
