# Peterson's Algorithm > Documents > References.md


## Description
All references to external logic. Includes anything from stack overflow links to notes about logic from previous works.


## New References
References new to this project.

### Python Multi-Processing and Multi-Threading
Similarly to "Logging Logic", I have an old Python project that I created a while ago to help myself understand
multi-processing/multi-threading through Python. I referenced this project for general threading logic setup.

* My Old Python Project: <https://git.brandon-rodriguez.com/python/example_projects/parallel_execution_example>
* Python Multiprocessing Docs: <https://docs.python.org/3.8/library/multiprocessing.html>
* Python CTypes Docs (Used for Shared Variables): <https://docs.python.org/3.8/library/ctypes.html>
* Calling a Threaded Func with Multiple Args: <https://stackoverflow.com/a/4463621>
* Python Docs for Functools (Solution to Above Item): <https://docs.python.org/3.8/library/functools.html>
* Threaded Shared Variables: <https://stackoverflow.com/a/17393879>
* Thread Not Any Displaying Output: <https://stackoverflow.com/a/25231062>

## Older Relevant References
References linked in previous assignments.

### Logging Logic
The contents of `resources/logging.py` (and all associated logic) originally started from me trying to
learn how to log information through Django (the Python Web Framework) using a Dictionary type format. (See
<https://docs.djangoproject.com/en/dev/topics/logging/> for reference).

In 2017, I started expanding and changing this logic to be usable in Non-Django applications, such as personal projects
and school assignments. After repeatedly importing and updating as needed, the logging.py file has slowly changed into
what it is today.

Logging files can be found in `resources/logs/`.

### Bash "cd to Script's Directory"
Used to move to the "Script's Directory", regardless of where the script was launched from in the terminal.
<https://stackoverflow.com/a/3355423>

### UnitTesting
Getting module imports to work correctly (-t arg):
<https://docs.python.org/3/library/unittest.html#test-discovery>

Running UnitTests from Console: <https://stackoverflow.com/a/15630454>.

Running UnitTests from Pycharm: Trial and error with modifying above references.

Running a single UnitTest: <https://stackoverflow.com/a/43029618>

### UnitTesting Subtests
Using subtests: <https://www.caktusgroup.com/blog/2017/05/29/subtests-are-best/>

### Using Pytest
General Documentation: <https://docs.pytest.org/en/latest/contents.html#toc>

Running PyTests from Pycharm: <https://www.jetbrains.com/help/pycharm/run-debug-configuration-py-test.html>

Running a single PyTest: <https://docs.pytest.org/en/latest/getting-started.html#create-your-first-test>

Issues with module imports: <https://stackoverflow.com/a/50610630>
