"""
Date: 10-30-19
Class: CS5310
Assignment: Peterson's Algorithm
Author: Brandon Rodriguez


<File Description Here>
"""

# System Imports.


# User Class Imports.
from resources import logging as init_logging
from resources.parallelism import Parallelism


# Initialize Logger.
logger = init_logging.get_logger(__name__)


def user_menu():
    logger.info('Choose an option:')
    logger.info('   1) Unsafe Multi-Processing.')
    logger.info('   2) Safe Multi-Processing.')
    logger.info('   3) Unsafe Multi-Threading.')
    logger.info('   4) Safe Multi-Threading.')
    logger.info('')
    user_input = str(input('')).strip()
    return user_input


if __name__ == '__main__':
    logger.info('Starting program.')

    user_menu_choice = user_menu()

    if user_menu_choice == '1':
        logger.info('Running "Unsafe Multi-Processing" Example.')
        logger.info('')
        Parallelism(False, multi_process=True)
    elif user_menu_choice == '2':
        logger.info('Running "Safe Multi-Processing" Example.')
        logger.info('')
        Parallelism(True, multi_process=True)
    elif user_menu_choice == '3':
        logger.info('Running "Unsafe Multi-Threading" Example.')
        logger.info('')
        Parallelism(False, multi_thread=True)
    elif user_menu_choice == '4':
        logger.info('Running "Safe Multi-Threading" Example.')
        logger.info('')
        Parallelism(True, multi_thread=True)
    else:
        logger.info('Unrecognized user menu choice.')
        logger.info('')

    logger.info('Terminating program.')
