/**
 * Date: 11-12-19
 * Class: CS5310
 * Assignment: Peterson's Algorithm
 * Author: Brandon Rodriguez
 *
 *
 * <File Description Here>
*/


// Import headers.
#include <ctype.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>


// Method Declaration.
void run_threads();
void *thread_a_method();
void *thread_b_method();


/**
 * Program's main. Initialized and runs program.
 */
int main(int argc, char* argv[]) {
    printf("Initializing program.\n");

    // Run threading function.
    run_threads();

    printf("Terminating program.\n");
    return 0;
}


/**
 * Function to create and manage threads.
 */
void run_threads() {
    printf("Starting threads...\n\n");

    // Declare variables.
    pthread_t* thread_pool;

    srand(time(NULL));

    // Create threads.
    thread_pool = calloc(2, sizeof(pthread_t));
    pthread_create(&thread_pool[0], NULL, thread_a_method, NULL);
    pthread_create(&thread_pool[1], NULL, thread_b_method, NULL);

    // Join threads.
    pthread_join(thread_pool[0], NULL);
    pthread_join(thread_pool[1], NULL);

    printf("\nThreads terminated.\n");
}


/**
 * Function for thread "a" to run.
 */
void *thread_a_method() {
    int random = rand() % 5;
    printf("Random int is: %d\n", random);
    sleep(random);

    printf("Thread a running.\n");

    return NULL;
}


/**
 * Function for thread "b" to run.
 */
void *thread_b_method() {
    int random = rand() % 5;
    printf("Random int is: %d\n", random);
    sleep(random);

    printf("Thread b running.\n");

    return NULL;
}
