# Graph Library > Documents > References.md


## Description
All references to external logic. Includes anything from stack overflow links to notes about logic from previous works.


## New References
References new to this project.

### Drawing Arrows for Directed Graph Connections
This ended up being more complicated than I expected.
* Main Ref was: <https://stackoverflow.com/a/51370419>
* Secondary Ref: <https://math.stackexchange.com/questions/428843/draw-directional-arrows-on-a-given-line>

### Trig "Cheat Sheet" to Help Determine Self-connecting Loop Coordinates
* <http://tutorial.math.lamar.edu/pdf/trig_cheat_sheet.pdf>

### Using Plotly for "Network Graphs"
* General Network Graph Info: <https://plot.ly/python/network-graphs/>
* General Examples of Plotly (Not Necessarily Network Graphs): <https://plot.ly/python/creating-and-updating-figures/>
* Line Breaks on Hover: <https://stackoverflow.com/questions/34878695/how-to-add-line-breaks-to-plotly-hover-labels>
* Plotly Args: <https://plot.ly/python/reference/#scatter>
* Examples of Plotly Labels/Hovertext/Etc: <https://plot.ly/python/text-and-annotations/>
* Examples of Plotly Markers: <https://plot.ly/python/marker-style/>

### Insights on Types of Graphs
To help determine to implement specialized graphs (directed, weighted, etc), I looked up definitions on different types
of graphs:
* <https://en.wikipedia.org/wiki/Graph_(discrete_mathematics)>
* <https://en.wikipedia.org/wiki/Directed_graph>

### General Graph Logic
During spring of 2018, I took the undergrad version of the "Algorithms" course (CS4310).

During that class, I did a "Graph Isomorphism" project. Project can be found at
<https://github.com/brodriguez8774/CS4310_Project>.

I tried to reference it minimally, but I definitely did reference it for "automatic naming" and "Visual Graph Display"
functionality.

### General Class Inheritance
<https://www.digitalocean.com/community/tutorials/understanding-class-inheritance-in-python-3>

### Class Inheritance Fix
At one point, essentially anytime an inheriting class called a parent function, the returned object was an instance of
the parent class, and thus only had access to the parent's functions.

For example, calling parent functions from "directed_graph" classes returned edge/node instances from the "basic_graph"
classes, limiting access to desired child logic.

The solution was similar to <https://stackoverflow.com/a/7840956>. The syntax I needed was a bit different, but after
some trial and error, the general idea worked.

### Circular Dependency Fix
The Node and Edge classes each import each other, so that they can check that they are being passed values of type
Node/Edge. Unfortunately, this appears to cause a circular dependency, which causes errors when using the standard
`from x import y` syntax.

More about this, as well as a solution is found at <https://stackabuse.com/python-circular-imports/>.

### Python "Private" Variables - Single VS Double Underscore
<https://stackoverflow.com/questions/6930144/underscore-vs-double-underscore-with-variables-and-methods>

### Python Floats and Ints Raised to a Power
<https://stackoverflow.com/questions/34258537/python-typeerror-unsupported-operand-types-for-float-and-int>

### Temporarily Disabling Logger
<https://stackoverflow.com/a/3116067>


## Older Relevant References
References linked in previous assignments.

### Logging Logic
The contents of `resources/logging.py` (and all associated logic) originally started from me trying to
learn how to log information through Django (the Python Web Framework) using a Dictionary type format. (See
<https://docs.djangoproject.com/en/dev/topics/logging/> for reference).

In 2017, I started expanding and changing this logic to be usable in Non-Django applications, such as personal projects
and school assignments. After repeatedly importing and updating as needed, the logging.py file has slowly changed into
what it is today.

Logging files can be found in `resources/logs/`.

### Bash "cd to Script's Directory"
Used to move to the "Script's Directory", regardless of where the script was launched from in the terminal.
<https://stackoverflow.com/a/3355423>

### UnitTesting
Getting module imports to work correctly (-t arg):
<https://docs.python.org/3/library/unittest.html#test-discovery>

Running UnitTests from Console: <https://stackoverflow.com/a/15630454>.

Running UnitTests from Pycharm: Trial and error with modifying above references.

Running a single UnitTest: <https://stackoverflow.com/a/43029618>

### UnitTesting Subtests
Using subtests: <https://www.caktusgroup.com/blog/2017/05/29/subtests-are-best/>

### Using Pytest
General Documentation: <https://docs.pytest.org/en/latest/contents.html#toc>

Running PyTests from Pycharm: <https://www.jetbrains.com/help/pycharm/run-debug-configuration-py-test.html>

Running a single PyTest: <https://docs.pytest.org/en/latest/getting-started.html#create-your-first-test>

Issues with module imports: <https://stackoverflow.com/a/50610630>
