"""
Date: 11-02-19
Class: CS5310
Assignment: Graph Library
Author: Brandon Rodriguez


Tests for "State Machine Node" class.
"""

# System Imports.
import unittest

# User Class Imports.
from resources import StateMachineEdge, StateMachineNode


class TestStateMachineNode(unittest.TestCase):
    def setUp(self):
        self.test_node = StateMachineNode('Test Node')

    def test__node_initialization(self):
        self.assertFalse(self.test_node.is_initial)
        self.assertFalse(self.test_node.is_final)

    def test__toggle_node_state_initial(self):
        # Test setting to True.
        self.test_node.toggle_node_state_initial()
        self.assertTrue(self.test_node.is_initial)

        # Test setting to False.
        self.test_node.toggle_node_state_initial()
        self.assertFalse(self.test_node.is_initial)

        # Test setting to True once more.
        self.test_node.toggle_node_state_initial()
        self.assertTrue(self.test_node.is_initial)

    def test__toggle_node_state_final(self):
        # Test setting to True.
        self.test_node.toggle_node_state_final()
        self.assertTrue(self.test_node.is_final)

        # Test setting to False.
        self.test_node.toggle_node_state_final()
        self.assertFalse(self.test_node.is_final)

        # Test setting to True once more.
        self.test_node.toggle_node_state_final()
        self.assertTrue(self.test_node.is_final)
