"""
Date: 10-02-19
Class: CS5310
Assignment: Graph Library
Author: Brandon Rodriguez


Tests for "State Machine Graph" class.
"""

# System Imports.
import unittest

# User Class Imports.
from resources import StateMachineEdge, StateMachineNode
from resources import StateMachineGraph


class TestDirectedGraph(unittest.TestCase):
    def setUp(self):
        self.test_graph = StateMachineGraph()

    def test__connect_nodes(self):
        # Create nodes to connect.
        node_1 = self.test_graph.create_node()
        node_2 = self.test_graph.create_node()
        node_3 = self.test_graph.create_node()
        node_4 = self.test_graph.create_node()

        # Check that all nodes start with 0 connections.
        self.assertEqual(node_1.get_edge_count(), 0)
        self.assertEqual(node_2.get_edge_count(), 0)
        self.assertEqual(node_3.get_edge_count(), 0)
        self.assertEqual(node_4.get_edge_count(), 0)

        # Test with 0 connections.
        edge_1 = self.test_graph.connect_nodes(node_1, node_2, 'a')
        # Check node connection count.
        self.assertEqual(node_1.get_edge_count(), 1)
        self.assertEqual(node_2.get_edge_count(), 1)
        self.assertEqual(node_3.get_edge_count(), 0)
        self.assertEqual(node_4.get_edge_count(), 0)
        # Check connection that was made.
        self.assertTrue(isinstance(edge_1, StateMachineEdge))
        connected_node_1, connected_node_2 = edge_1.get_nodes().values()
        self.assertEqual(connected_node_1, node_1)
        self.assertEqual(connected_node_2, node_2)
        self.assertEqual(edge_1.state_change_conditions, ['a'])

        # Test with 1 connection.
        edge_2 = self.test_graph.connect_nodes(node_1, node_3, 'b')
        # Check node connection count.
        self.assertEqual(node_1.get_edge_count(), 2)
        self.assertEqual(node_2.get_edge_count(), 1)
        self.assertEqual(node_3.get_edge_count(), 1)
        self.assertEqual(node_4.get_edge_count(), 0)
        # Check connection that was made.
        self.assertTrue(isinstance(edge_2, StateMachineEdge))
        connected_node_1, connected_node_3 = edge_2.get_nodes().values()
        self.assertEqual(connected_node_1, node_1)
        self.assertEqual(connected_node_3, node_3)
        self.assertEqual(edge_2.state_change_conditions, ['b'])

        # Test with 2 connections.
        edge_3 = self.test_graph.connect_nodes(node_1, node_4, 'c')
        # Check node connection count.
        self.assertEqual(node_1.get_edge_count(), 3)
        self.assertEqual(node_2.get_edge_count(), 1)
        self.assertEqual(node_3.get_edge_count(), 1)
        self.assertEqual(node_4.get_edge_count(), 1)
        # Check connection that was made.
        self.assertTrue(isinstance(edge_3, StateMachineEdge))
        connected_node_1, connected_node_4 = edge_3.get_nodes().values()
        self.assertEqual(connected_node_1, node_1)
        self.assertEqual(connected_node_4, node_4)
        self.assertEqual(edge_3.state_change_conditions, ['c'])

        # Works with 0, 1, and 2 connections. Assuming works with all further n connections.

    def test__toggle_node_state_initial(self):
        # Create node to toggle.
        node_1 = self.test_graph.create_node()
        node_2 = self.test_graph.create_node()
        node_3 = self.test_graph.create_node()

        with self.subTest('Adding initial/start states.'):
            # Test initial values.
            self.assertFalse(node_1.is_initial)
            self.assertFalse(node_2.is_initial)
            self.assertFalse(node_3.is_initial)
            self.assertEqual(self.test_graph._initial_states, {})

            # Test add with 0 initial states.
            node_1.toggle_node_state_initial()
            self.assertTrue(node_1.is_initial)
            self.assertFalse(node_2.is_initial)
            self.assertFalse(node_3.is_initial)
            self.assertEqual(self.test_graph._initial_states, {node_1.get_name(): node_1})

            # Test add with 1 initial states.
            node_2.toggle_node_state_initial()
            self.assertTrue(node_1.is_initial)
            self.assertTrue(node_2.is_initial)
            self.assertFalse(node_3.is_initial)
            self.assertEqual(self.test_graph._initial_states, {node_1.get_name(): node_1, node_2.get_name(): node_2})

            # Test add with 2 initial states.
            node_3.toggle_node_state_initial()
            self.assertTrue(node_1.is_initial)
            self.assertTrue(node_2.is_initial)
            self.assertTrue(node_3.is_initial)
            self.assertEqual(self.test_graph._initial_states, {
                node_1.get_name(): node_1,
                node_2.get_name(): node_2,
                node_3.get_name(): node_3,
            })

            # Works with 0, 1, and 2 initial/start states. Assuming works with all further n initial/start states.

        with self.subTest('Removing initial/start states.'):
            # Test initial values.
            self.assertTrue(node_1.is_initial)
            self.assertTrue(node_2.is_initial)
            self.assertTrue(node_3.is_initial)
            self.assertEqual(self.test_graph._initial_states, {
                node_1.get_name(): node_1,
                node_2.get_name(): node_2,
                node_3.get_name(): node_3,
            })

            # Test remove with 3 initial states.
            node_1.toggle_node_state_initial()
            self.assertFalse(node_1.is_initial)
            self.assertTrue(node_2.is_initial)
            self.assertTrue(node_3.is_initial)
            self.assertEqual(self.test_graph._initial_states, {node_2.get_name(): node_2, node_3.get_name(): node_3})

            # Test remove with 2 initial states.
            node_3.toggle_node_state_initial()
            self.assertFalse(node_1.is_initial)
            self.assertTrue(node_2.is_initial)
            self.assertFalse(node_3.is_initial)
            self.assertEqual(self.test_graph._initial_states, {node_2.get_name(): node_2})

            # Test remove with 1 initial states.
            node_2.toggle_node_state_initial()
            self.assertFalse(node_1.is_initial)
            self.assertFalse(node_2.is_initial)
            self.assertFalse(node_3.is_initial)
            self.assertEqual(self.test_graph._initial_states, {})

            # Works with 1, 2, and 3 initial/start states. Assuming works with all further n initial/start states.

    def test__toggle_node_state_final(self):
        # Create node to toggle.
        node_1 = self.test_graph.create_node()
        node_2 = self.test_graph.create_node()
        node_3 = self.test_graph.create_node()

        with self.subTest('Adding final states.'):
            # Test initial values.
            self.assertFalse(node_1.is_final)
            self.assertFalse(node_2.is_final)
            self.assertFalse(node_3.is_final)
            self.assertEqual(self.test_graph._final_states, {})

            # Test add with 0 initial states.
            node_1.toggle_node_state_final()
            self.assertTrue(node_1.is_final)
            self.assertFalse(node_2.is_final)
            self.assertFalse(node_3.is_final)
            self.assertEqual(self.test_graph._final_states, {node_1.get_name(): node_1})

            # Test add with 1 initial states.
            node_2.toggle_node_state_final()
            self.assertTrue(node_1.is_final)
            self.assertTrue(node_2.is_final)
            self.assertFalse(node_3.is_final)
            self.assertEqual(self.test_graph._final_states, {node_1.get_name(): node_1, node_2.get_name(): node_2})

            # Test add with 2 initial states.
            node_3.toggle_node_state_final()
            self.assertTrue(node_1.is_final)
            self.assertTrue(node_2.is_final)
            self.assertTrue(node_3.is_final)
            self.assertEqual(self.test_graph._final_states, {
                node_1.get_name(): node_1,
                node_2.get_name(): node_2,
                node_3.get_name(): node_3,
            })

            # Works with 0, 1, and 2 final states. Assuming works with all further n final states.

        with self.subTest('Removing final states.'):
            # Test initial values.
            self.assertTrue(node_1.is_final)
            self.assertTrue(node_2.is_final)
            self.assertTrue(node_3.is_final)
            self.assertEqual(self.test_graph._final_states, {
                node_1.get_name(): node_1,
                node_2.get_name(): node_2,
                node_3.get_name(): node_3,
            })

            # Test remove with 3 initial states.
            node_1.toggle_node_state_final()
            self.assertFalse(node_1.is_final)
            self.assertTrue(node_2.is_final)
            self.assertTrue(node_3.is_final)
            self.assertEqual(self.test_graph._final_states, {node_2.get_name(): node_2, node_3.get_name(): node_3})

            # Test remove with 2 initial states.
            node_3.toggle_node_state_final()
            self.assertFalse(node_1.is_final)
            self.assertTrue(node_2.is_final)
            self.assertFalse(node_3.is_final)
            self.assertEqual(self.test_graph._final_states, {node_2.get_name(): node_2})

            # Test remove with 1 initial states.
            node_2.toggle_node_state_final()
            self.assertFalse(node_1.is_final)
            self.assertFalse(node_2.is_final)
            self.assertFalse(node_3.is_final)
            self.assertEqual(self.test_graph._final_states, {})

            # Works with 1, 2, and 3 final states. Assuming works with all further n final states.
