"""
Date: 11-02-19
Class: CS5310
Assignment: Graph Library
Author: Brandon Rodriguez


Tests for "State Machine Edge" class.
"""

# System Imports.
import unittest

# User Class Imports.
from resources import StateMachineEdge, StateMachineNode


class TestStateMachineEdge(unittest.TestCase):
    def setUp(self):
        self.test_edge = StateMachineEdge('Test Edge')
        self.head_node = StateMachineNode('Head Node')
        self.tail_node = StateMachineNode('Tail Node')

    def test__edge_initialization(self):
        self.assertEqual(self.test_edge.state_change_conditions, [])

    def test__add_state_change_condition__success(self):
        with self.subTest('With adding single conditions.'):
            # Check initial value.
            self.assertEqual(self.test_edge.state_change_conditions, [])

            # Test adding with 0 state change conditions.
            self.test_edge.add_state_change_condition('a')
            self.assertEqual(self.test_edge.state_change_conditions, ['a'])

            # Test adding with 1 state change condition.
            self.test_edge.add_state_change_condition(123)
            self.assertEqual(self.test_edge.state_change_conditions, ['a', '123'])

            # Test adding with 2 state change conditions.
            self.test_edge.add_state_change_condition('c')
            self.assertEqual(self.test_edge.state_change_conditions, ['a', '123', 'c'])

            # Works with 0, 1, and 2 state conditions. Assuming works with all further n state conditions.

            # Reset state change conditions for next subtest.
            self.test_edge.remove_state_change_condition(['a', '123', 'c'])

        with self.subTest('With adding multiple conditions - As list.'):
            # Check initial value.
            self.assertEqual(self.test_edge.state_change_conditions, [])

            # Test adding 1 state change condition.
            self.test_edge.add_state_change_condition(['a'])
            self.assertEqual(self.test_edge.state_change_conditions, ['a'])

            # Test adding 2 state change conditions.
            self.test_edge.add_state_change_condition([123, 'b'])
            self.assertEqual(self.test_edge.state_change_conditions, ['a', '123', 'b'])

            # Test adding 3 state change conditions.
            self.test_edge.add_state_change_condition([456, 'c', '15'])
            self.assertEqual(self.test_edge.state_change_conditions, ['a', '123', 'b', '456', 'c', '15'])

            # Works with 1, 2, and 3 state conditions. Assuming works with all further n state conditions.

            # Reset state change conditions for next subtest.
            self.test_edge.remove_state_change_condition(['a', '123', 'b', '456', 'c', '15'])

        with self.subTest('With adding multiple conditions - As tuple.'):
            # Check initial value.
            self.assertEqual(self.test_edge.state_change_conditions, [])

            # Test adding 1 state change condition.
            self.test_edge.add_state_change_condition(('a',))
            self.assertEqual(self.test_edge.state_change_conditions, ['a'])

            # Test adding 2 state change conditions.
            self.test_edge.add_state_change_condition((123, 'b'))
            self.assertEqual(self.test_edge.state_change_conditions, ['a', '123', 'b'])

            # Test adding 3 state change conditions.
            self.test_edge.add_state_change_condition((456, 'c', '15'))
            self.assertEqual(self.test_edge.state_change_conditions, ['a', '123', 'b', '456', 'c', '15'])

            # Works with 1, 2, and 3 state conditions. Assuming works with all further n state conditions.

    def test__add_state_change_condition__failure(self):
        # Add initial value.
        self.test_edge.add_state_change_condition('a')
        self.assertEqual(self.test_edge.state_change_conditions, ['a'])

        with self.subTest('Value already exists.'):
            self.test_edge.add_state_change_condition('a')
            self.assertEqual(self.test_edge.state_change_conditions, ['a'])

    def test__remove_state_change_condition__success(self):
        with self.subTest('With adding single conditions.'):
            # Populate initial values.
            self.test_edge.add_state_change_condition('a')
            self.test_edge.add_state_change_condition(123)
            self.test_edge.add_state_change_condition('c')
            self.assertEqual(self.test_edge.state_change_conditions, ['a', '123', 'c'])

            # Test removal with 3 state change conditions.
            self.test_edge.remove_state_change_condition('c')
            self.assertEqual(self.test_edge.state_change_conditions, ['a', '123'])

            # Test removal with 2 state change conditions.
            self.test_edge.remove_state_change_condition('a')
            self.assertEqual(self.test_edge.state_change_conditions, ['123'])

            # Test removal with 1 state change condition.
            self.test_edge.remove_state_change_condition(123)
            self.assertEqual(self.test_edge.state_change_conditions, [])

            # Works with 1, 2, and 3 state conditions. Assuming works with all further n state conditions.

        with self.subTest('With adding multiple conditions - As list.'):
            # Populate initial values.
            self.test_edge.add_state_change_condition(['a', 'b', 'c', 'd', 'e', 'f'])
            self.assertEqual(self.test_edge.state_change_conditions, ['a', 'b', 'c', 'd', 'e', 'f'])

            # Test removing 3 state change conditions.
            self.test_edge.remove_state_change_condition(['a', 'c', 'd'])
            self.assertEqual(self.test_edge.state_change_conditions, ['b', 'e', 'f'])

            # Test removing 2 state change conditions.
            self.test_edge.remove_state_change_condition(['b', 'f'])
            self.assertEqual(self.test_edge.state_change_conditions, ['e'])

            # Test removing 1 state change conditions.
            self.test_edge.remove_state_change_condition(['e'])
            self.assertEqual(self.test_edge.state_change_conditions, [])

            # Works with 1, 2, and 3 state conditions. Assuming works with all further n state conditions.

        with self.subTest('With adding multiple conditions - As tuple.'):
            # Populate initial values.
            self.test_edge.add_state_change_condition(['a', 'b', 'c', 'd', 'e', 'f'])
            self.assertEqual(self.test_edge.state_change_conditions, ['a', 'b', 'c', 'd', 'e', 'f'])

            # Test removing 3 state change conditions.
            self.test_edge.remove_state_change_condition(('a', 'c', 'd'))
            self.assertEqual(self.test_edge.state_change_conditions, ['b', 'e', 'f'])

            # Test removing 2 state change conditions.
            self.test_edge.remove_state_change_condition(('b', 'f'))
            self.assertEqual(self.test_edge.state_change_conditions, ['e'])

            # Test removing 1 state change conditions.
            self.test_edge.remove_state_change_condition(('e',))
            self.assertEqual(self.test_edge.state_change_conditions, [])

            # Works with 1, 2, and 3 state conditions. Assuming works with all further n state conditions.

    def test__remove_state_change_condition__failure(self):
        with self.subTest('Change condition is None.'):
            with self.assertRaises(ValueError):
                self.test_edge.remove_state_change_condition(None)

        with self.subTest('No values present.'):
            self.test_edge.remove_state_change_condition('a')
            self.assertEqual(self.test_edge.state_change_conditions, [])

        # Populate with some initial values.
        self.test_edge.add_state_change_condition('b')
        self.test_edge.add_state_change_condition('c')
        self.assertEqual(self.test_edge.state_change_conditions, ['b', 'c'])

        with self.subTest('Value not found.'):
            self.test_edge.remove_state_change_condition('a')
            self.assertEqual(self.test_edge.state_change_conditions, ['b', 'c'])

    def test__connect_nodes__success(self):
        # We have pretty thorough testing of the parent function.
        # Thus, just test that state is properly added to edge.
        self.test_edge.connect_nodes(self.tail_node, self.head_node, 'a')
        self.assertEqual(self.test_edge.state_change_conditions, ['a'])

    def test__connect_nodes__failure(self):
        with self.subTest('Change condition is None.'):
            with self.assertRaises(ValueError):
                self.test_edge.connect_nodes(self.tail_node, self.head_node, None)
