"""
Date: 09-12-19
Class: CS5310
Assignment: Graph Library
Author: Brandon Rodriguez


Tests for "Directed Node" class.
"""

# System Imports.
import unittest

# User Class Imports.
from resources import DirectedEdge, DirectedNode


class TestDirectedNode(unittest.TestCase):
    def setUp(self):
        self.test_node = DirectedNode('Test Node')

    #region Information Functions

    def test__get_outgoing_edges(self):
        # Create nodes to connect.
        node_1 = DirectedNode('Node 1')
        node_2 = DirectedNode('Node 2')

        # Test getting outgoing edges with 0 connections.
        self.assertEqual(self.test_node.get_outgoing_edges(), [])

        # Test getting outgoing edges with 1 connection.
        edge_1 = self.test_node.connect_node(node_1)
        self.assertEqual(self.test_node.get_outgoing_edges(), [edge_1])

        # Test getting outgoing edges with 2 connection.
        edge_2 = self.test_node.connect_node(node_2)
        self.assertEqual(self.test_node.get_outgoing_edges(), [edge_1, edge_2])

        # Works with 0, 1, and 2 connections. Assuming works with all further n connections.

    def test__get_incoming_edges(self):
        # Create nodes to connect.
        node_1 = DirectedNode('Node 1')
        node_2 = DirectedNode('Node 2')

        # Test getting outgoing edges with 0 connections.
        self.assertEqual(self.test_node.get_incoming_edges(), [])

        # Test getting outgoing edges with 1 connection.
        edge_1 = self.test_node.connect_node(node_1, direct_towards_neighbor=False)
        self.assertEqual(self.test_node.get_incoming_edges(), [edge_1])

        # Test getting outgoing edges with 2 connection.
        edge_2 = self.test_node.connect_node(node_2, direct_towards_neighbor=False)
        self.assertEqual(self.test_node.get_incoming_edges(), [edge_1, edge_2])

        # Works with 0, 1, and 2 connections. Assuming works with all further n connections.

    def test__get_outgoing_nodes(self):
        # Create nodes to connect.
        node_1 = DirectedNode('Node 1')
        node_2 = DirectedNode('Node 2')

        # Test getting outgoing edges with 0 connections.
        self.assertEqual(self.test_node.get_outgoing_nodes(), [])

        # Test getting outgoing edges with 1 connection.
        self.test_node.connect_node(node_1)
        self.assertEqual(self.test_node.get_outgoing_nodes(), [node_1])

        # Test getting outgoing edges with 2 connection.
        self.test_node.connect_node(node_2)
        self.assertEqual(self.test_node.get_outgoing_nodes(), [node_1, node_2])

        # Works with 0, 1, and 2 connections. Assuming works with all further n connections.

    def test__get_incoming_nodes(self):
        # Create nodes to connect.
        node_1 = DirectedNode('Node 1')
        node_2 = DirectedNode('Node 2')

        # Test getting outgoing edges with 0 connections.
        self.assertEqual(self.test_node.get_incoming_nodes(), [])

        # Test getting outgoing edges with 1 connection.
        self.test_node.connect_node(node_1, direct_towards_neighbor=False)
        self.assertEqual(self.test_node.get_incoming_nodes(), [node_1])

        # Test getting outgoing edges with 2 connection.
        self.test_node.connect_node(node_2, direct_towards_neighbor=False)
        self.assertEqual(self.test_node.get_incoming_nodes(), [node_1, node_2])

        # Works with 0, 1, and 2 connections. Assuming works with all further n connections.

    #endregion Information Functions

    #region Upkeep Functions

    def test__connect_node__success(self):
        # We have pretty thorough testing of the parent function.
        # Thus, just test that neighboring order (head/tail) is properly observed.

        # Create nodes to connect.
        node_1 = DirectedNode('Node 1')
        node_2 = DirectedNode('Node 2')

        # Test connection where neighbor node is head.
        edge_1 = self.test_node.connect_node(node_1, direct_towards_neighbor=True)
        self.assertTrue(isinstance(edge_1, DirectedEdge))
        self.assertEqual(self.test_node.get_edge_by_connected_node(node_1).get_tail_node(), self.test_node)
        self.assertEqual(self.test_node.get_edge_by_connected_node(node_1).get_head_node(), node_1)

        # Test connection where neighbor node is tail.
        edge_2 = self.test_node.connect_node(node_2, direct_towards_neighbor=False)
        self.assertTrue(isinstance(edge_2, DirectedEdge))
        self.assertEqual(self.test_node.get_edge_by_connected_node(node_2).get_tail_node(), node_2)
        self.assertEqual(self.test_node.get_edge_by_connected_node(node_2).get_head_node(), self.test_node)

    def test__connect_node__failure(self):
        with self.subTest('With arg not of type node.'):
            with self.assertRaises(TypeError):
                self.test_node.connect_node(1234)

    def test__disconnect_node(self):
        # We have pretty thorough testing of the parent function.
        # Thus, just test returned edge is of "Directed" type.
        node_1 = DirectedNode('Node 1')
        self.test_node.connect_node(node_1)
        edge_1 = self.test_node.disconnect_node(node_identifier=node_1)
        self.assertTrue(isinstance(edge_1, DirectedEdge))

    #endregion Upkeep Functions
