"""
Date: 09-12-19
Class: CS5310
Assignment: Graph Library
Author: Brandon Rodriguez


Tests for "Directed Graph" class.
"""

# System Imports.
import unittest

# User Class Imports.
from resources import DirectedEdge, DirectedNode
from resources import DirectedGraph


class TestDirectedGraph(unittest.TestCase):
    def setUp(self):
        self.test_graph = DirectedGraph()

    def test__create_node(self):
        # We have pretty thorough testing of the parent function.
        # Thus, just test returned node is of "Directed" type.
        node_1 = self.test_graph.create_node()
        self.assertTrue(isinstance(node_1, DirectedNode))

    def test__remove_node(self):
        # We have pretty thorough testing of the parent function.
        # Thus, just test returned node is of "Directed" type.
        node_1 = self.test_graph.create_node()
        node_1 = self.test_graph.remove_node(node_1)
        self.assertTrue(isinstance(node_1, DirectedNode))

    def test__connect_node(self):
        # We have pretty thorough testing of the parent function.
        # Thus, just test returned edge is of "Directed" type.
        node_1 = self.test_graph.create_node()
        node_2 = self.test_graph.create_node()
        edge_1 = self.test_graph.connect_nodes(node_1, node_2)
        self.assertTrue(isinstance(edge_1, DirectedEdge))

    def test__disconnect_node(self):
        # We have pretty thorough testing of the parent function.
        # Thus, just test returned edge is of "Directed" type.
        node_1 = self.test_graph.create_node()
        node_2 = self.test_graph.create_node()
        self.test_graph.connect_nodes(node_1, node_2)
        edge_1 = self.test_graph.disconnect_nodes(node_1_identifier=node_1, node_2_identifier=node_2)
        self.assertTrue(isinstance(edge_1, DirectedEdge))
