"""
Date: 09-12-19
Class: CS5310
Assignment: Graph Library
Author: Brandon Rodriguez


Tests for "Directed Edge" class.
"""

# System Imports.
import unittest

# User Class Imports.
from resources import DirectedEdge, DirectedNode


class TestDirectedEdge(unittest.TestCase):
    def setUp(self):
        self.test_edge = DirectedEdge('Test Edge')
        self.head_node = DirectedNode('Head Node')
        self.tail_node = DirectedNode('Tail Node')

    #region Information Functions

    def test__get_nodes(self):
        # We have pretty thorough testing of the parent function.
        # Thus, just test that head/tail node are returned in proper positions within dictionary.
        self.test_edge.connect_nodes(self.tail_node, self.head_node)
        node_dict = self.test_edge.get_nodes()
        self.assertTrue(isinstance(node_dict, dict))
        self.assertEqual(node_dict['head_node'], self.head_node)
        self.assertEqual(node_dict['tail_node'], self.tail_node)

    def test__get_tail_node__success(self):
        self.test_edge.connect_nodes(self.tail_node, self.head_node)
        self.assertEqual(self.test_edge.get_tail_node(), self.tail_node)

    def test__get_tail_node__failure(self):
        with self.subTest('No nodes connected.'):
            self.assertIsNone(self.test_edge.get_tail_node())

    def test__get_outgoing_node__success(self):
        self.test_edge.connect_nodes(self.tail_node, self.head_node)
        self.assertEqual(self.test_edge.get_outgoing_node(), self.tail_node)

    def test__get_outgoing_node__failure(self):
        with self.subTest('No nodes connected.'):
            self.assertIsNone(self.test_edge.get_outgoing_node())

    def test__get_head_node__success(self):
        self.test_edge.connect_nodes(self.tail_node, self.head_node)
        self.assertEqual(self.test_edge.get_head_node(), self.head_node)

    def test__get_head_node__failure(self):
        with self.subTest('No nodes connected.'):
            self.assertIsNone(self.test_edge.get_head_node())

    def test__get_incoming_node__success(self):
        self.test_edge.connect_nodes(self.tail_node, self.head_node)
        self.assertEqual(self.test_edge.get_incoming_node(), self.head_node)

    def test__get_incoming_node__failure(self):
        with self.subTest('No nodes connected.'):
            self.assertIsNone(self.test_edge.get_incoming_node())

    #endregion Information Functions

    #region Upkeep Functions

    def test__connect_nodes(self):
        # We have pretty thorough testing of the parent function.
        # Thus, just test that "tail node" is first in node list and "head node" is second in node list.
        self.test_edge.connect_nodes(self.tail_node, self.head_node)
        self.assertEqual(self.test_edge._nodes[0], self.tail_node)
        self.assertEqual(self.test_edge._nodes[1], self.head_node)

    def test__invert_edge_direction(self):
        # First connect nodes.
        self.test_edge.connect_nodes(self.tail_node, self.head_node)

        # Verify start state.
        self.assertEqual(self.test_edge.get_head_node(), self.head_node)
        self.assertEqual(self.test_edge.get_tail_node(), self.tail_node)

        # Test inverting edge direction.
        self.test_edge.invert_edge_direction()
        self.assertEqual(self.test_edge.get_head_node(), self.tail_node)
        self.assertEqual(self.test_edge.get_tail_node(), self.head_node)

        # To be sure, test inverting back to original state.
        self.test_edge.invert_edge_direction()
        self.assertEqual(self.test_edge.get_head_node(), self.head_node)
        self.assertEqual(self.test_edge.get_tail_node(), self.tail_node)

    def test__connect_node_to_self(self):
        self.test_edge._nodes_can_self_connect = True
        self.test_edge.connect_nodes(self.tail_node, self.tail_node)
        self.assertEqual(self.test_edge.get_nodes(), {
            'tail_node': self.tail_node,
            'head_node': self.tail_node,
        })

    #endregion Upkeep Functions
