"""
Date: 09-12-19
Class: CS5310
Assignment: Graph Library
Author: Brandon Rodriguez


Tests for "Basic Node" class.
"""

# System Imports.
import unittest

# User Class Imports.
from resources import BasicEdge, BasicNode


class TestBasicNode(unittest.TestCase):
    def setUp(self):
        self.edge_name = 'Test Edge Name'
        self.node_name = 'Test Node Name'
        self.test_node = BasicNode(self.node_name)

    def test__node_initialization(self):
        self.assertEqual(self.test_node.get_name(), self.node_name)
        self.assertEqual(self.test_node.get_edge_count(), 0)
        self.assertEqual(self.test_node.get_edges(), {})
        self.assertEqual(self.test_node.get_connected_nodes(), {})
        self.assertIsNone(self.test_node._graph)

    #region Information Function Tests

    def test__get_name(self):
        self.assertTrue(isinstance(self.test_node.get_name(), str))
        self.assertEqual(self.test_node.get_name(), self.node_name)

    def test__get_edge_count(self):
        # Create nodes to connect.
        node_1 = BasicNode('Node 1')
        node_2 = BasicNode('Node 2')

        # Test with no connections.
        self.assertEqual(self.test_node.get_edge_count(), 0)

        # Test with one connection.
        self.test_node.connect_node(node_1)
        self.assertEqual(self.test_node.get_edge_count(), 1)

        # Test with two connections.
        self.test_node.connect_node(node_2)
        self.assertEqual(self.test_node.get_edge_count(), 2)

        # Works with 0, 1, and 2 connections. Assuming works with all further n connections.

    def test__get_connected_node_count(self):
        # Create nodes to connect.
        node_1 = BasicNode('Node 1')
        node_2 = BasicNode('Node 2')

        # Test with no connections.
        self.assertEqual(self.test_node.get_connected_node_count(), 0)

        # Test with one connection.
        self.test_node.connect_node(node_1)
        self.assertEqual(self.test_node.get_connected_node_count(), 1)

        # Test with two connections.
        self.test_node.connect_node(node_2)
        self.assertEqual(self.test_node.get_connected_node_count(), 2)

        # Works with 0, 1, and 2 connections. Assuming works with all further n connections.

    def test__get_edges(self):
        # Create nodes to connect.
        node_1 = BasicNode('Node 1')
        node_2 = BasicNode('Node 2')

        # Test with no connections.
        self.assertEqual(self.test_node.get_edges(), {})

        # Test with one connection.
        edge_1 = self.test_node.connect_node(node_1)
        self.assertTrue(self.test_node.get_edges(), {
            edge_1.get_name(): edge_1,
        })

        # Test with two connections.
        edge_2 = self.test_node.connect_node(node_2)
        self.assertTrue(self.test_node.get_edges(), {
            edge_1.get_name(): edge_1,
            edge_2.get_name(): edge_2,
        })

        # Works with 0, 1, and 2 connections. Assuming works with all further n connections.

    def test__get_connected_nodes(self):
        # Create nodes to connect.
        node_1 = BasicNode('Node 1')
        node_2 = BasicNode('Node 2')

        # Test with no connections.
        self.assertEqual(self.test_node.get_edges(), {})

        # Test with one connection.
        self.test_node.connect_node(node_1)
        self.assertTrue(self.test_node.get_connected_nodes(), {
            node_1.get_name(): node_1,
        })

        # Test with two connections.
        self.test_node.connect_node(node_2)
        self.assertTrue(self.test_node.get_connected_nodes(), {
            node_1.get_name(): node_1,
            node_2.get_name(): node_2,
        })

        # Works with 0, 1, and 2 connections. Assuming works with all further n connections.

    def test__get_edge__success(self):
        # Create and connect nodes.
        node_1 = BasicNode('Node 1')
        node_2 = BasicNode('Node 2')
        edge_1 = self.test_node.connect_node(node_1)
        edge_2 = self.test_node.connect_node(node_2)

        with self.subTest('Get edge by Edge class.'):
            # Test first edge.
            returned_edge = self.test_node.get_edge(edge_1)
            self.assertEqual(returned_edge, edge_1)

            # Test second edge.
            returned_edge = self.test_node.get_edge(edge_2)
            self.assertEqual(returned_edge, edge_2)

        with self.subTest('Get edge by Edge name.'):
            # Test first edge.
            returned_edge = self.test_node.get_edge(edge_1.get_name())
            self.assertEqual(returned_edge, edge_1)

            # Test second edge.
            returned_edge = self.test_node.get_edge(edge_2.get_name())
            self.assertEqual(returned_edge, edge_2)

    def test__get_edge__failure(self):
        with self.subTest('Arg of type None.'):
            with self.assertRaises(AttributeError):
                self.test_node.get_edge(None)

        with self.subTest('Edge not connected to node - by Edge class.'):
            edge_1 = BasicEdge('Edge 1')
            with self.assertLogs(level='WARNING'):
                self.assertIsNone(self.test_node.get_edge(edge_1))

        with self.subTest('Edge not connected to node - by Edge name.'):
            with self.assertLogs(level='WARNING'):
                self.assertIsNone(self.test_node.get_edge('Test'))

    def test__get_edge_by_connected_node__success(self):
        # Create and connect nodes.
        node_1 = BasicNode('Node 1')
        node_2 = BasicNode('Node 2')
        edge_1 = self.test_node.connect_node(node_1)
        edge_2 = self.test_node.connect_node(node_2)

        with self.subTest('Get edge by Node class.'):
            # Test first edge.
            returned_edge = self.test_node.get_edge_by_connected_node(node_1)
            self.assertEqual(returned_edge, edge_1)

            # Test second edge.
            returned_edge = self.test_node.get_edge_by_connected_node(node_2)
            self.assertEqual(returned_edge, edge_2)

        with self.subTest('Get edge by Node name.'):
            # Test first edge.
            returned_edge = self.test_node.get_edge_by_connected_node(node_1.get_name())
            self.assertEqual(returned_edge, edge_1)

            # Test second edge.
            returned_edge = self.test_node.get_edge_by_connected_node(node_2.get_name())
            self.assertEqual(returned_edge, edge_2)

    def test__get_edge_by_connected_node__failure(self):
        with self.subTest('Arg of type None.'):
            with self.assertRaises(AttributeError):
                self.test_node.get_edge_by_connected_node(None)

        with self.subTest('Node not found in connections - by Node class.'):
            node_1 = BasicNode('Node 1')
            with self.assertLogs(level='WARNING'):
                self.assertIsNone(self.test_node.get_edge_by_connected_node(node_1))

        with self.subTest('Node not found in connections - by Node name.'):
            with self.assertLogs(level='WARNING'):
                self.assertIsNone(self.test_node.get_edge_by_connected_node('Test'))

    def test__determine_node_adjacency__success(self):
        # Create nodes to connect.
        node_1 = BasicNode('Node 1')
        node_2 = BasicNode('Node 2')
        node_3 = BasicNode('Node 3')

        # Connect nodes 1 and 3.
        self.test_node.connect_node(node_1)
        self.test_node.connect_node(node_3)

        with self.subTest('Test adjacency by Node class.'):
            # Test adjacency of node 1.
            self.assertTrue(self.test_node.determine_node_adjacency(node_1))
            self.assertTrue(node_1.determine_node_adjacency(self.test_node))

            # Test adjacency of node 2.
            self.assertFalse(self.test_node.determine_node_adjacency(node_2))
            self.assertFalse(node_2.determine_node_adjacency(self.test_node))

            # Test adjacency of node 3.
            self.assertTrue(self.test_node.determine_node_adjacency(node_3))
            self.assertTrue(node_3.determine_node_adjacency(self.test_node))

        with self.subTest('Test adjacency by Node name.'):
            # Test adjacency of node 1.
            self.assertTrue(self.test_node.determine_node_adjacency(node_1.get_name()))
            self.assertTrue(node_1.determine_node_adjacency(self.test_node.get_name()))

            # Test adjacency of node 2.
            self.assertFalse(self.test_node.determine_node_adjacency(node_2.get_name()))
            self.assertFalse(node_2.determine_node_adjacency(self.test_node.get_name()))

            # Test adjacency of node 3.
            self.assertTrue(self.test_node.determine_node_adjacency(node_3.get_name()))
            self.assertTrue(node_3.determine_node_adjacency(self.test_node.get_name()))

    def test__determine_node_adjacency__failure(self):
        with self.subTest('Arg of type None'):
            with self.assertRaises(AttributeError):
                self.test_node.determine_node_adjacency(None)

    #endregion Information Function Tests

    #region Upkeep Function Tests

    def test__connect_node__success(self):
        with self.subTest('With automatic edge names.'):
            # Create nodes to connect.
            node_1 = BasicNode('Node 1')
            node_2 = BasicNode('Node 2')
            node_3 = BasicNode('Node 3')

            # Test with no connections.
            edge_1 = self.test_node.connect_node(node_1)
            # Check edges connected to node.
            self.assertEqual(self.test_node.get_edge_count(), 1)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
            })
            # Check new edge values.
            self.assertTrue(isinstance(edge_1, BasicEdge))
            self.assertEqual(edge_1.get_name(), '{0} to Node 1'.format(self.node_name))

            # Test with one connection.
            edge_2 = self.test_node.connect_node(node_2)
            # Check edges connected to node.
            self.assertEqual(self.test_node.get_edge_count(), 2)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
            })
            # Check new edge values.
            self.assertTrue(isinstance(edge_2, BasicEdge))
            self.assertEqual(edge_2.get_name(), '{0} to Node 2'.format(self.node_name))

            # Test with one connections.
            edge_3 = self.test_node.connect_node(node_3)
            # Check edges connected to node.
            self.assertEqual(self.test_node.get_edge_count(), 3)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
                edge_3.get_name(): edge_3,
            })
            # Check new edge values.
            self.assertTrue(isinstance(edge_3, BasicEdge))
            self.assertEqual(edge_3.get_name(), '{0} to Node 3'.format(self.node_name))

            # Works with 0, 1, and 2 connections. Assuming works with all further n connections.

        with self.subTest('With manual edge names.'):
            # Reset node cuz subtests.
            self.test_node = BasicNode(self.node_name)

            # Create nodes to connect.
            node_1 = BasicNode('Node 1')
            node_2 = BasicNode('Node 1')
            node_3 = BasicNode('Node 1')

            # Test with no connections.
            edge_1 = self.test_node.connect_node(node_1, edge_name='Test Edge 1')
            # Check edges connected to node.
            self.assertEqual(self.test_node.get_edge_count(), 1)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
            })
            # Check new edge values.
            self.assertTrue(isinstance(edge_1, BasicEdge))
            self.assertEqual(edge_1.get_name(), 'Test Edge 1')

            # Test with one connection.
            edge_2 = self.test_node.connect_node(node_2, edge_name='Test Edge 2')
            # Check edges connected to node.
            self.assertEqual(self.test_node.get_edge_count(), 2)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
            })
            # Check new edge values.
            self.assertTrue(isinstance(edge_2, BasicEdge))
            self.assertEqual(edge_2.get_name(), 'Test Edge 2')

            # Test with one connections.
            edge_3 = self.test_node.connect_node(node_3, edge_name='Test Edge 3')
            # Check edges connected to node.
            self.assertEqual(self.test_node.get_edge_count(), 3)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
                edge_3.get_name(): edge_3,
            })
            # Check new edge values.
            self.assertTrue(isinstance(edge_3, BasicEdge))
            self.assertEqual(edge_3.get_name(), 'Test Edge 3')

            # Works with 0, 1, and 2 connections. Assuming works with all further n connections.

    def test__connect_node__failure(self):
        with self.subTest('Arg is not of type Node.'):
            with self.assertRaises(TypeError):
                self.test_node.connect_node(1234)

    def test__disconnect_node__success(self):
        # Create nodes to connect.
        node_1 = BasicNode('Node 1')
        node_2 = BasicNode('Node 2')
        node_3 = BasicNode('Node 3')

        with self.subTest('Disconnect by Node class'):
            # Connect nodes.
            edge_1 = self.test_node.connect_node(node_1)
            edge_2 = self.test_node.connect_node(node_2)
            edge_3 = self.test_node.connect_node(node_3)

            # Verify start state.
            self.assertEqual(self.test_node.get_edge_count(), 3)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
                edge_3.get_name(): edge_3,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 3)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_1.get_name(): node_1,
                node_2.get_name(): node_2,
                node_3.get_name(): node_3,
            })

            # Disconnect with 3 connections.
            disconnected_edge = self.test_node.disconnect_node(node_1)
            self.assertEqual(disconnected_edge, edge_1)
            self.assertEqual(self.test_node.get_edge_count(), 2)
            self.assertEqual(self.test_node.get_edges(), {
                edge_2.get_name(): edge_2,
                edge_3.get_name(): edge_3,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 2)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_2.get_name(): node_2,
                node_3.get_name(): node_3,
            })

            # Disconnect with 2 connections.
            disconnected_edge = self.test_node.disconnect_node(node_2)
            self.assertEqual(disconnected_edge, edge_2)
            self.assertEqual(self.test_node.get_edge_count(), 1)
            self.assertEqual(self.test_node.get_edges(), {
                edge_3.get_name(): edge_3,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 1)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_3.get_name(): node_3,
            })

            # Disconnect with 1 connection.
            disconnected_edge = self.test_node.disconnect_node(node_3)
            self.assertEqual(disconnected_edge, edge_3)
            self.assertEqual(self.test_node.get_edge_count(), 0)
            self.assertEqual(self.test_node.get_edges(), {})
            self.assertEqual(self.test_node.get_connected_node_count(), 0)
            self.assertEqual(self.test_node.get_connected_nodes(), {})

            # Works with 1, 2, and 3 connections. Assuming works with all further n connections.

        with self.subTest('Disconnect by Node name.'):
            # Connect nodes.
            edge_1 = self.test_node.connect_node(node_1)
            edge_2 = self.test_node.connect_node(node_2)
            edge_3 = self.test_node.connect_node(node_3)

            # Verify start state.
            self.assertEqual(self.test_node.get_edge_count(), 3)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
                edge_3.get_name(): edge_3,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 3)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_1.get_name(): node_1,
                node_2.get_name(): node_2,
                node_3.get_name(): node_3,
            })

            # Disconnect with 3 connections.
            disconnected_edge = self.test_node.disconnect_node('Node 1')
            self.assertEqual(disconnected_edge, edge_1)
            self.assertEqual(self.test_node.get_edge_count(), 2)
            self.assertEqual(self.test_node.get_edges(), {
                edge_2.get_name(): edge_2,
                edge_3.get_name(): edge_3,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 2)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_2.get_name(): node_2,
                node_3.get_name(): node_3,
            })

            # Disconnect with 2 connections.
            disconnected_edge = self.test_node.disconnect_node('Node 2')
            self.assertEqual(disconnected_edge, edge_2)
            self.assertEqual(self.test_node.get_edge_count(), 1)
            self.assertEqual(self.test_node.get_edges(), {
                edge_3.get_name(): edge_3,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 1)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_3.get_name(): node_3,
            })

            # Disconnect with 1 connection.
            disconnected_edge = self.test_node.disconnect_node('Node 3')
            self.assertEqual(disconnected_edge, edge_3)
            self.assertEqual(self.test_node.get_edge_count(), 0)
            self.assertEqual(self.test_node.get_edges(), {})
            self.assertEqual(self.test_node.get_connected_node_count(), 0)
            self.assertEqual(self.test_node.get_connected_nodes(), {})

            # Works with 1, 2, and 3 connections. Assuming works with all further n connections.

        with self.subTest('Disconnect by Edge class.'):
            # Connect nodes.
            edge_1 = self.test_node.connect_node(node_1)
            edge_2 = self.test_node.connect_node(node_2)
            edge_3 = self.test_node.connect_node(node_3)

            # Verify start state.
            self.assertEqual(self.test_node.get_edge_count(), 3)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
                edge_3.get_name(): edge_3,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 3)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_1.get_name(): node_1,
                node_2.get_name(): node_2,
                node_3.get_name(): node_3,
            })

            # Disconnect with 3 connections.
            disconnected_edge = self.test_node.disconnect_node(edge_identifier=edge_1)
            self.assertEqual(disconnected_edge, edge_1)
            self.assertEqual(self.test_node.get_edge_count(), 2)
            self.assertEqual(self.test_node.get_edges(), {
                edge_2.get_name(): edge_2,
                edge_3.get_name(): edge_3,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 2)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_2.get_name(): node_2,
                node_3.get_name(): node_3,
            })

            # Disconnect with 2 connections.
            disconnected_edge = self.test_node.disconnect_node(edge_identifier=edge_2)
            self.assertEqual(disconnected_edge, edge_2)
            self.assertEqual(self.test_node.get_edge_count(), 1)
            self.assertEqual(self.test_node.get_edges(), {
                edge_3.get_name(): edge_3,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 1)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_3.get_name(): node_3,
            })

            # Disconnect with 1 connection.
            disconnected_edge = self.test_node.disconnect_node(edge_identifier=edge_3)
            self.assertEqual(disconnected_edge, edge_3)
            self.assertEqual(self.test_node.get_edge_count(), 0)
            self.assertEqual(self.test_node.get_edges(), {})
            self.assertEqual(self.test_node.get_connected_node_count(), 0)
            self.assertEqual(self.test_node.get_connected_nodes(), {})

            # Works with 1, 2, and 3 connections. Assuming works with all further n connections.

        with self.subTest('Disconnect by Edge name.'):
            # Connect nodes.
            edge_1 = self.test_node.connect_node(node_1, 'Edge 1')
            edge_2 = self.test_node.connect_node(node_2, 'Edge 2')
            edge_3 = self.test_node.connect_node(node_3, 'Edge 3')

            # Verify start state.
            self.assertEqual(self.test_node.get_edge_count(), 3)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
                edge_3.get_name(): edge_3,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 3)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_1.get_name(): node_1,
                node_2.get_name(): node_2,
                node_3.get_name(): node_3,
            })

            # Disconnect with 3 connections.
            disconnected_edge = self.test_node.disconnect_node(edge_identifier='Edge 1')
            self.assertEqual(disconnected_edge, edge_1)
            self.assertEqual(self.test_node.get_edge_count(), 2)
            self.assertEqual(self.test_node.get_edges(), {
                edge_2.get_name(): edge_2,
                edge_3.get_name(): edge_3,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 2)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_2.get_name(): node_2,
                node_3.get_name(): node_3,
            })

            # Disconnect with 2 connections.
            disconnected_edge = self.test_node.disconnect_node(edge_identifier='Edge 2')
            self.assertEqual(disconnected_edge, edge_2)
            self.assertEqual(self.test_node.get_edge_count(), 1)
            self.assertEqual(self.test_node.get_edges(), {
                edge_3.get_name(): edge_3,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 1)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_3.get_name(): node_3,
            })

            # Disconnect with 1 connection.
            disconnected_node = self.test_node.disconnect_node(edge_identifier='Edge 3')
            self.assertEqual(disconnected_node, edge_3)
            self.assertEqual(self.test_node.get_edge_count(), 0)
            self.assertEqual(self.test_node.get_edges(), {})
            self.assertEqual(self.test_node.get_connected_node_count(), 0)
            self.assertEqual(self.test_node.get_connected_nodes(), {})

            # Works with 1, 2, and 3 connections. Assuming works with all further n connections.

        with self.subTest('With two way node connection - by Node.'):
            # Connect nodes.
            edge_1 = self.test_node.connect_node(node_1, 'Edge 1')
            edge_2 = node_1.connect_node(self.test_node, 'Edge 2')

            # Verify start state.
            self.assertEqual(self.test_node.get_edge_count(), 2)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 1)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_1.get_name(): node_1,
            })
            self.assertEqual(node_1.get_edge_count(), 2)
            self.assertEqual(node_1.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
            })
            self.assertEqual(node_1.get_connected_node_count(), 1)
            self.assertEqual(node_1.get_connected_nodes(), {
                self.test_node.get_name(): self.test_node,
            })

            # Test removing node_1 from test_node.
            self.test_node.disconnect_node(node_identifier=node_1)
            self.assertEqual(self.test_node.get_edge_count(), 0)
            self.assertEqual(self.test_node.get_edges(), {})
            self.assertEqual(self.test_node.get_connected_node_count(), 0)
            self.assertEqual(self.test_node.get_connected_nodes(), {})
            self.assertEqual(node_1.get_edge_count(), 0)
            self.assertEqual(node_1.get_edges(), {})
            self.assertEqual(node_1.get_connected_node_count(), 0)
            self.assertEqual(node_1.get_connected_nodes(), {})

            # Reconnect nodes.
            edge_1 = self.test_node.connect_node(node_1, 'Edge 1')
            edge_2 = node_1.connect_node(self.test_node, 'Edge 2')

            # Reverify start state.
            self.assertEqual(self.test_node.get_edge_count(), 2)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 1)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_1.get_name(): node_1,
            })
            self.assertEqual(node_1.get_edge_count(), 2)
            self.assertEqual(node_1.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
            })
            self.assertEqual(node_1.get_connected_node_count(), 1)
            self.assertEqual(node_1.get_connected_nodes(), {
                self.test_node.get_name(): self.test_node,
            })

            # Test removing test_node from node_1.
            node_1.disconnect_node(node_identifier=self.test_node)
            self.assertEqual(self.test_node.get_edge_count(), 0)
            self.assertEqual(self.test_node.get_edges(), {})
            self.assertEqual(self.test_node.get_connected_node_count(), 0)
            self.assertEqual(self.test_node.get_connected_nodes(), {})
            self.assertEqual(node_1.get_edge_count(), 0)
            self.assertEqual(node_1.get_edges(), {})
            self.assertEqual(node_1.get_connected_node_count(), 0)
            self.assertEqual(node_1.get_connected_nodes(), {})

        with self.subTest('With two way node connection - by Edge.'):
            # Connect nodes.
            edge_1 = self.test_node.connect_node(node_1, 'Edge 1')
            edge_2 = node_1.connect_node(self.test_node, 'Edge 2')

            # Verify start state.
            self.assertEqual(self.test_node.get_edge_count(), 2)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 1)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_1.get_name(): node_1,
            })
            self.assertEqual(node_1.get_edge_count(), 2)
            self.assertEqual(node_1.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
            })
            self.assertEqual(node_1.get_connected_node_count(), 1)
            self.assertEqual(node_1.get_connected_nodes(), {
                self.test_node.get_name(): self.test_node,
            })

            # Test removing via first edge.
            self.test_node.disconnect_node(edge_identifier=edge_1)
            self.assertEqual(self.test_node.get_edge_count(), 0)
            self.assertEqual(self.test_node.get_edges(), {})
            self.assertEqual(self.test_node.get_connected_node_count(), 0)
            self.assertEqual(self.test_node.get_connected_nodes(), {})
            self.assertEqual(node_1.get_edge_count(), 0)
            self.assertEqual(node_1.get_edges(), {})
            self.assertEqual(node_1.get_connected_node_count(), 0)
            self.assertEqual(node_1.get_connected_nodes(), {})

            # Reconnect nodes.
            edge_1 = self.test_node.connect_node(node_1, 'Edge 1')
            edge_2 = node_1.connect_node(self.test_node, 'Edge 2')

            # Re-verify start state.
            self.assertEqual(self.test_node.get_edge_count(), 2)
            self.assertEqual(self.test_node.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
            })
            self.assertEqual(self.test_node.get_connected_node_count(), 1)
            self.assertEqual(self.test_node.get_connected_nodes(), {
                node_1.get_name(): node_1,
            })
            self.assertEqual(node_1.get_edge_count(), 2)
            self.assertEqual(node_1.get_edges(), {
                edge_1.get_name(): edge_1,
                edge_2.get_name(): edge_2,
            })
            self.assertEqual(node_1.get_connected_node_count(), 1)
            self.assertEqual(node_1.get_connected_nodes(), {
                self.test_node.get_name(): self.test_node,
            })

            # Test removing via second edge.
            self.test_node.disconnect_node(edge_identifier=edge_2)
            self.assertEqual(self.test_node.get_edge_count(), 0)
            self.assertEqual(self.test_node.get_edges(), {})
            self.assertEqual(self.test_node.get_connected_node_count(), 0)
            self.assertEqual(self.test_node.get_connected_nodes(), {})
            self.assertEqual(node_1.get_edge_count(), 0)
            self.assertEqual(node_1.get_edges(), {})
            self.assertEqual(node_1.get_connected_node_count(), 0)
            self.assertEqual(node_1.get_connected_nodes(), {})

    def test__disconnect_node__failure(self):
        with self.subTest('No connections present.'):
            with self.assertRaises(ValueError):
                self.test_node.disconnect_node('Test')

        # Create at least one connection to avoid accidentally replicating above "no connections present" subtest.
        self.assertEqual(self.test_node.get_edge_count(), 0)
        node_1 = BasicNode('Node 1')
        node_2 = BasicNode('Node 2')
        edge_1 = self.test_node.connect_node(node_1)
        edge_2 = BasicEdge('Edge 2')

        with self.subTest('No args provided.'):
            # Should have one connection, from above subtests.
            self.assertEqual(self.test_node.get_edge_count(), 1)

            # Test with no args.
            with self.assertRaises(AttributeError):
                self.test_node.disconnect_node()

            # Check that connection count hasn't changed.
            self.assertEqual(self.test_node.get_edge_count(), 1)

        with self.subTest('Both args provided at once.'):
            # Should have one connection, from above subtests.
            self.assertEqual(self.test_node.get_edge_count(), 1)

            # Test with both args filled.
            with self.assertRaises(AttributeError):
                self.test_node.disconnect_node(node_identifier=0, edge_identifier=0)

            # Check that connection count hasn't changed.
            self.assertEqual(self.test_node.get_edge_count(), 1)

        with self.subTest('Valid node arg provided, but given node not found in connections.'):
            # Should have one connection, from above subtests.
            self.assertEqual(self.test_node.get_edge_count(), 1)

            # Test with node arg that isn't found in connections. Arg is Node class.
            with self.assertLogs(level='WARNING'):
                self.assertIsNone(self.test_node.disconnect_node(node_identifier=node_2))

            # Test with node arg that isn't found in connections. Arg is Node name.
            with self.assertLogs(level='WARNING'):
                self.assertIsNone(self.test_node.disconnect_node(node_identifier='Test'))

            # Check that connection count hasn't changed.
            self.assertEqual(self.test_node.get_edge_count(), 1)

        with self.subTest('Valid edge arg provided, but given edge not found in connections.'):
            # Should have one connection, from above subtests.
            self.assertEqual(self.test_node.get_edge_count(), 1)

            # Test with node arg that isn't found in connections. Arg is Edge class.
            with self.assertLogs(level='WARNING'):
                self.assertIsNone(self.test_node.disconnect_node(edge_identifier=edge_2))

            # Test with node arg that isn't found in connections. Arg is Edge name.
            with self.assertLogs(level='WARNING'):
                self.assertIsNone(self.test_node.disconnect_node(edge_identifier='Test'))

            # Check that connection count hasn't changed.
            self.assertEqual(self.test_node.get_edge_count(), 1)

    #endregion Upkeep Function Tests
