/*
  Read in 3 user arguments and output a number in a given base.
    Specifically, get value and take in initial base.
    Convert to universal base as intermediary step,
    then convert to desired ending base.

  Uses three seperate functions, depending on what base(s) are used.

  TODO:
    NEEDS VALIDATION OF BASES.
    NEEDS CREATION OF MASK/SHIFT AND 256 FUNCTIONS.
        Mask/Shift:
            Input to base 10.
            Base 10 to output.
        256:
            Input to base 10.
            Base 10 to output.
        DivAlg:
            Input to base 10.
        BE LESS CONFUSED.
            Why is this so confusing aaa.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "DivAlg.c"
#include "TwoFiveSixAlg.c"
#include "MaskShiftAlg.c"


int IsPowerOfTwo(unsigned int x);


int main(int argc, char * argv[]) {

    // Initialize Variables.
    unsigned int inputInt;        // Input stored as an int. NOT NEEDED?
    unsigned int initialBaseInt;  // The base initially read in as.
    unsigned int convertBaseInt;  // The desired base to convert to.
    char* baseTenValue = NULL;
    char* convertBaseValue = NULL;
    char* remainderTable = "0123456789ABCDEF";

    // Needed because, for some reason, pointer values that are passed back before being printed
    // seem to irrationally return blank? Yet simply printing them first magically makes it
    // have the intended values. Makes no sense, but seems to be how it is. Thus, they'll be
    // printed on this "DebugLine."
    printf("DebugLine: ");

    // As long as at least 3 arguments have been provided,
    if (argc > 3) {
        // Aquire input and base values.
        char* input = argv[1];
        initialBaseInt = atoi(argv[2]);
        convertBaseInt = atoi(argv[3]);
        // Chooses which of 3 functions to use according to initial base.
        if (IsPowerOfTwo(initialBaseInt) == 1) {
            printf("   DEBUGGING: Determined power of 2");
            if (initialBaseInt == 256) {
                // Pass to TwoFiveSixAlg.
                baseTenValue = TwoFiveSixAlg(input, initialBaseInt, 1);
            } else {
                // Pass to MaskShiftAlg.
                baseTenValue = MaskShiftAlg(input, initialBaseInt, 1);
            }
        } else {
            // Pass to DivAlg.
            baseTenValue = DivAlg(input, initialBaseInt, 1);
        }

        // Choose which of 3 functions to use according to desired end base.
        if (IsPowerOfTwo(convertBaseInt) == 1) {
            if (convertBaseInt == 256) {
                // Pass to TwoFiveSixAlg.
                convertBaseValue = TwoFiveSixAlg(baseTenValue, convertBaseInt, 0);
            } else {
                // Pass to MaskShiftAlg.
                convertBaseValue = MaskShiftAlg(baseTenValue, convertBaseInt, 0);
            }
        } else {
            // Pass to DivAlg.
            convertBaseValue = DivAlg(baseTenValue, convertBaseInt, 0);
        }

        printf("\n The input value %s (of base %u) is equavlent to: \n Base 10: %s \n Base %u: %s \n",
                input, initialBaseInt, baseTenValue, convertBaseInt, convertBaseValue);
    } else {
        printf("Please input at least 3 arguments. \n");
        printf("1st Arg: Value to convert to a new base. \n");
        printf("2nd Arg: The current base of value. \n");
        printf("3rd Arg: The base to convert to. \n");
    }

    return 0;
}

// Determine if value is a power of 2.
// Continually divides by two, as long as x > 1.
// If x = 1, then it's a power of two. If x becomes odd before hand, then it's not.
int IsPowerOfTwo (unsigned int x) {

    while (((x % 2) == 0) && (x > 1)) {
        x = (x / 2);
    }

    if (x == 1) {
        return x;
    } else {
        return 0;
    }
}
