
// Converts most bases.
// Note: C doesn't have bools? Thus read in is 1 for true and 0 for false.


char* DivToBaseTen(char* input, unsigned int base);
char* DivFromBaseTen(char* input, unsigned int base);
void SwapValues(char* x, char* y);


char* DivAlg(char* input, unsigned int base, int readInBool) {

    // Check to make sure value isn't already in base 10.
    if (base == 10) {
        return input;
    } else {
        if (readInBool == 1) {
            return DivToBaseTen(input, base);
        } else {
            return DivFromBaseTen(input, base);
        }
    }
}


char* DivToBaseTen(char* input, unsigned int base) {

    // TODO: Debugging statement.
    printf("   Starting DivAlg ToBaseTen. \n");

    // Initialize Variables.
    int index;                           // Working index.
    int stringLength = strlen(input);    // Holds length of string.
    unsigned int inputInt = atoi(input); // Input as int for processing.
    unsigned int tempInt1;               // Temp int for doing math.
    unsigned int tempInt2;
    char outputString[32];               // String for output values.
    char* remainderTable = "0123456789ABCDEF";

    // Copy from input to outputString.
    strncpy(outputString, input, stringLength);

    // Create swap pointers and swap values.
    stringLength--;
    char* strPointer1 = &outputString[0];
    char* strPointer2 = &outputString[stringLength];

    while (strPointer1 < strPointer2) {
        SwapValues(strPointer1, strPointer2);
        strPointer1++;
        strPointer2--;
    }

    // Do math to find base 10 values.
    tempInt1 = 0;
    for (index = 0; index <= stringLength; index++) {
        tempInt2 = (input[index] - '0');
        tempInt1 = (tempInt1 * base + tempInt2);
    }

    // Create buffer to pass back.
    sprintf(outputString, "%u", tempInt1);
    char* buffer = malloc(stringLength + 2);
    strncpy(buffer, outputString, stringLength + 2);

    return buffer;
}


char* DivFromBaseTen(char* input, unsigned int base) {

    // TODO: Debugging Statement.
    printf("   Starting DivAlg FromBaseTen \n");

    // Initialize Variables.
    int index = 0;                       // Working index.
    unsigned int inputInt = atoi(input); // Input as int for processing.
    char outputString[32];               // String for output values.
    char tempChar;                       // TempChar for swapping values.
    char* remainderTable = "0123456789ABCDEF";

    // Do math to find converted values.
    while (inputInt != 0) {
        // Get and store remainder for output.
        outputString[index] = remainderTable[inputInt % base];
        // Find next value to divide by for next loop.
        inputInt = inputInt / base;
        index++;
    }

    // Create buffer to pass back.
    int stringLength = (strlen(outputString) - 1);
    // Create swap pointers.
    char* strPointer1 = &outputString[0];
    char* strPointer2 = &outputString[stringLength];

    // Swap values into proper order.
    stringLength--;
    while (strPointer1 < strPointer2) {
        SwapValues(strPointer1, strPointer2);
        strPointer1++;
        strPointer2--;
    }

    // TODO: Why the heck is buffer blank unless I print it prior to passing it back to main?
    char* buffer = malloc(stringLength + 2);
    strncpy(buffer, outputString, stringLength + 2);
    printf("%s", buffer);
    return buffer;
}


// Swap passed values.
void SwapValues(char* x, char* y) {

    char temp = *x;
    *x = *y;
    *y = temp;
}
