"""urls.py"""
from django.conf.urls import url

from volunteer.views import (
    view_volunteer_topics,
    edit_volunteer_topic,
    new_volunteer,
)

app_name = 'volunteer'
urlpatterns = [
    url(r'^topics/$', view_volunteer_topics, name='view_volunteer_topics'),
    url(r'^topics/edit/(?P<topic_pk>\d+)$', edit_volunteer_topic,
        name='edit_volunteer_topic'),
    url(r'^new/$', new_volunteer, name='new_volunteer'),
]
