# -*- coding: utf-8 -*-
# Generated by Django 1.9.1 on 2016-02-21 07:42
from __future__ import unicode_literals

import ckeditor_uploader.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Volunteer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subscribed', models.BooleanField(default=False, help_text='Receive emails when this topic is updated?')),
            ],
        ),
        migrations.CreateModel(
            name='VolunteerCode',
            fields=[
                ('code', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('expired', models.BooleanField(default=False)),
                ('date_created', models.DateField(auto_now_add=True)),
                ('expires_after', models.PositiveSmallIntegerField(default=7, help_text='How many days is this code valid?')),
            ],
        ),
        migrations.CreateModel(
            name='VolunteerTopic',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('content', ckeditor_uploader.fields.RichTextUploadingField()),
                ('last_modified', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Volunteer Topic',
                'ordering': ['name'],
            },
        ),
        migrations.AddField(
            model_name='volunteercode',
            name='topics',
            field=models.ManyToManyField(to='volunteer.VolunteerTopic'),
        ),
        migrations.AddField(
            model_name='volunteer',
            name='topic',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='volunteers', to='volunteer.VolunteerTopic'),
        ),
        migrations.AddField(
            model_name='volunteer',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AlterUniqueTogether(
            name='volunteer',
            unique_together=set([('user', 'topic')]),
        ),
    ]
