function isSizeMobile(size) {
    // webkit removes double quotes
    if (size == '"mobile"' || size == 'mobile')
        return true;
    return false;
}

function isSizeWidescreen(size) {
    // webkit removes double quotes
    if (size == '"widescreen"' || size == 'widescreen')
        return true;
    return false;
}

// Ensure entire page loads first.
$(document).ready(function() {


    // Main code here. Changes layout of top navigation to be more mobile friendly.

    /**************************************************
    ************** Screen Size Dependant Section **************
    **************************************************/

    var size;
    var displayType;
    var mobileInitializeBool = true;

    // Run once on page load. Used to determine initial screen size.
    if (mobileInitializeBool) {
    // Get current value of the "body:after" "content" property.
        size = window.getComputedStyle(document.body,':after').getPropertyValue('content');
        displayType = size;

        if (isSizeMobile(size)) {
            OnScreenResizeToMobile();
        }

        $("footer .nav-wrapper .nav-sublink a").addClass("round-top-extra round-bottom-extra");
        mobileInitializeBool = false;
    }


    // On window resize, determine if mobile or desktop layout is appropriate.
    $(window).resize(function() {
        // Get current value of the "body:after" "content" property.
        size = window.getComputedStyle(document.body,':after').getPropertyValue('content');

        // As long as display type did not change (is still equal to size property),
        // then do not do screen resize logic.
            if (displayType != size) {
                if (isSizeMobile(size)) {
                    OnScreenResizeToMobile();
                    displayType = size;
                } else {
                    if (isSizeWidescreen(size)) {
                        OnScreenResizeToDesktop();
                    displayType = size;
                }
            }
        }
    });

    /**************************************************
    ************** Main Nav Link Section **************
    **************************************************/

    /*************************
    *****Icon Change on Hover*****
    *************************/

    $(".mobile-nav-icon-wrapper").mouseenter(function() {
        $(this).children(".mobile-nav-icon-bars").addClass("display-none").removeClass("display-block");
        $(this).children(".mobile-nav-icon-bars-red").addClass("display-block").removeClass("display-none");
    });

    $(".mobile-nav-icon-wrapper").mouseleave(function() {
        $(this).children(".mobile-nav-icon-bars").addClass("display-block").removeClass("display-none");
        $(this).children(".mobile-nav-icon-bars-red").addClass("display-none").removeClass("display-block");
    });


    /*************************
    *****Togggle Main Nav Window*****
    *************************/

    // Show/hide menu on icon click.
    $(".mobile-nav-icon-wrapper").on("click", function() {

        // Toggle if menu is selected.
        if ($(this).hasClass("selected")) {
            $(this).removeClass("selected");
        } else {
            ($(this).addClass("selected"));
        }

        ToggleMainMenus();
    });

    function ToggleMainMenus () {
        // Check menu toggle and display accordingly.
        if ($(".mobile-nav-icon-wrapper").hasClass("selected")) {
            $("#header-nav .nav-wrapper").addClass("display-flex").removeClass("display-none");
        } else {
            $("#header-nav .nav-wrapper").addClass("display-none").removeClass("display-flex");
        }
    }


    /*************************
    *****Togggle SiteMap Window*****
    *************************/

    // Show/hide menu on icon click.
    $("footer .sitemap-toggle").on("click", function() {

        // Toggle if menu is selected.
        if ($(this).hasClass("selected")) {
            $(this).removeClass("selected");
        } else {
            ($(this).addClass("selected"));
        }

        ToggleSiteMapMenus();
    });

    function ToggleSiteMapMenus () {
        // Check menu toggle and display accordingly.
        if ($("footer .sitemap-toggle").hasClass("selected")) {
            $("footer .nav-wrapper").addClass("display-flex").removeClass("display-none");
        } else {
            $("footer .nav-wrapper").addClass("display-none").removeClass("display-flex");
        }
    }


    /*************************
    *****Togggle Main Nav Submenus*****
    *************************/

    // Show submenus on user click of associated main menu item.
    $(document).on("click", "#header-nav .vert-nav .nav-link", function() {

        // Check if clicked class is selected or not.
        if ($(this).hasClass("selected")) {
            // Remove "selected" class from clicked nav item and all siblings, if present.
            $(this).removeClass("selected").siblings(".selected").removeClass("selected");
        } else {
            // Add "selected" class to clicked nav item and remove from all siblings, if present.
            $(this).addClass("selected").siblings(".selected").removeClass("selected");
        }

        ToggleSubMenus();
    });

    function ToggleSubMenus () {
        // Go through each main nav and test for selected. Display submenus accordingly.
        $("#header-nav .vert-nav .nav-link").each(function() {
            if ($(this).hasClass("selected")) {
                $(this).children(".nav-sub-menu").addClass("display-flex").removeClass("display-none");
            } else {
                $(this).children(".nav-sub-menu").addClass("display-none").removeClass("display-flex");
            }
        });
    }


    /*************************
    *****Togggle SiteMap Submenus*****
    *************************/

    // Show submenus on user click of associated main menu item.
    $(document).on("click", "footer .nav-wrapper .nav-link", function() {

        // Check if clicked class is selected or not.
        if ($(this).hasClass("selected")) {
            // Remove "selected" class from clicked nav item and all siblings, if present.
            $(this).removeClass("selected").siblings(".selected").removeClass("selected");
        } else {
            // Add "selected" class to clicked nav item and remove from all siblings, if present.
            $(this).addClass("selected").siblings(".selected").removeClass("selected");
        }

        ToggleSiteMapSubMenus();
    });

    function ToggleSiteMapSubMenus () {
        // Go through each main nav and test for selected. Display submenus accordingly.
        $("footer .nav-wrapper .nav-link").each(function() {
            if ($(this).hasClass("selected")) {
                $(this).children(".nav-sub-menu").addClass("display-flex").removeClass("display-none");
            } else {
                $(this).children(".nav-sub-menu").addClass("display-none").removeClass("display-flex");
            }
        });
    }


    /**************************************************
    ************* Other Functions Section *************
    **************************************************/

    // Change settings if window is changed to mobile (<= 1000px) size.
    function OnScreenResizeToMobile () {

        // Setup for mobile layout.
        // Set mobile bars to display.
        $(".mobile-nav-icon-bars").addClass("display-block");
        // Set navigation to vertical mode.
        $("#header-nav .nav-wrapper").addClass("vert-nav").removeClass("horiz-nav");
        // Soften submenu edges.
        $("#header-nav .nav-sublink a").addClass("round-top-extra round-bottom-extra");

        // Hide tourn dates
        $(".nav-tourn-dates").hide();

        ToggleMainMenus();
        ToggleSubMenus();
    }

    // Change settings if window is changed to desktop (> 1000px) size.
    function OnScreenResizeToDesktop () {

        // Reset and hide main mobile nav on resize to desktop.

        // Remove mobile-set classes from mobile icon.
        $(".mobile-nav-icon-bars").removeClass("display-none display-block");
        $(".mobile-nav-icon-bars-red").removeClass("display-none display-block");
        $(".mobile-nav-icon-wrapper").removeClass("selected");

        // Remove mobile-set classes from header nav.
        $("#header-nav .nav-wrapper").removeClass("display-none display-flex");

        // Remove mobile-set classes from nav submenus.
        $(".nav-sub-menu").removeClass("display-none display-flex");

        // Set navigation to horizontal mode.
        $("#header-nav .nav-wrapper").addClass("horiz-nav").removeClass("vert-nav");

        // Reset submenu edges.
        $("#header-nav .nav-sublink a").removeClass("round-top-extra round-bottom-extra");

        // Show tourn dates
        $(".nav-tourn-dates").show();
    }



});
