// Wait for entire page to load first.
$(document).ready(function() {
    // Create banner buttons in JS, as there's no reason to
    // display them if JS is disabled.

    // Holds the interval id to stop it later
    var bannerTimer;


    /**************************************************
    ************** Initialize Banner **************
    **************************************************/
    var bannerInitializeBool = true;

    if (bannerInitializeBool) {

        SelectBanner();
        var idInt;

        bannerInitializeBool == false;
    }

    /**************************************************
    ************** Banner Event Handling **************
    **************************************************/

    // Stop timer while mouse is over banner to prevent the user from
    // accidently clicking to go to another banners url
    $("#banner-wrapper").mouseenter(function() {
        if (bannerTimer)
            window.clearInterval(bannerTimer);
    });

    $("#banner-wrapper").mouseleave(function() {
        ResetBannerTimer();
    });

    /**************************************************
    ************** Arrow Event Handling **************
    **************************************************/

    $(".arrow-right-e").css("display", "block");
    $(".arrow-left-e").css("display", "block");

    // Handling for mousing over arrow buttons.
    // Left arrow mouseover.
    $(".arrow-container-left").mouseenter(function() {
        $(".arrow-left-e").css("display", "none");
        $(".arrow-left-f").css("display", "block");
    });

    $(".arrow-container-left").mouseleave(function() {
        $(".arrow-left-f").css("display", "none");
        $(".arrow-left-e").css("display", "block");
    });

    // Right arrow mouseover.
    $(".arrow-container-right").mouseenter(function() {
        $(".arrow-right-e").css("display", "none");
        $(".arrow-right-f").css("display", "block");
    });

    $(".arrow-container-right").mouseleave(function() {
        $(".arrow-right-f").css("display", "none");
        $(".arrow-right-e").css("display", "block");
    });

    // Arrow Click Events.
    $(document).on("click", ".arrow-container-right", function() {
        // Reset timer to start from now
        ResetBannerTimer();
        CycleBannerUp();
        SelectBanner();
    });

    $(document).on("click", ".arrow-container-left", function() {
        // Reset timer to start from now
        ResetBannerTimer();
        CycleBannerDown();
        SelectBanner();
    });

    /**************************************************
    ************** Banner Methods **************
    **************************************************/

    // Swap out visible banner stuff based on selection.
    function SelectBanner() {
        // Hide all banners
        $(".banner-image").hide();

        // Show specific banner
        $("#banner-image-" + bannerIndex).show();

        // Change banner url.
        $("#banner-url").attr('href', BannerObj[bannerIndex].url);

        // Change banner url target and title
        if (BannerObj[bannerIndex].sponsor) {
            $("#banner-url").attr('target', '_blank');
            $("#banner-url").attr('title', BannerObj[bannerIndex].sponsor_name);
        } else {
            $("#banner-url").removeAttr('target');
            $("#banner-url").removeAttr('title');
        }

        // Change banner text.
        $("#banner-text p").text(function() {
            return BannerObj[bannerIndex].description;
        });

        $("#banner-sponsor-level p").text(function() {
            if (!BannerObj[bannerIndex].sponsor_level) {
                $("#banner-sponsor-level").hide();
                return "";
            }
            $("#banner-sponsor-level").show();
            return BannerObj[bannerIndex].sponsor_level;
        });

        // Change banner text alignment.
        // Remove all possible alignments.
        $("#banner-text").removeClass("align-far-left");
        $("#banner-text").removeClass("align-left");
        $("#banner-text").removeClass("align-right");
        $("#banner-text").removeClass("align-far-right");

        // Set to current alignment.
        $("#banner-text").addClass(BannerObj[bannerIndex].alignment);

        ShowSelectedMarker();
    }

    // Selecting Banner Index
    // Use regular expressions to determine index of banner to select.
    function GetID(aString) {

        // Regex which only finds match of an int.
        var myRegex = /\d+/;
        idInt = myRegex.exec(aString)[0];
    }

    // Cycle Banner up.
    function CycleBannerUp() {
        // Hide current marker
        HideSelectedMarker();

        // Check if there is another banner in queue (upward).
        if (bannerIndex < (BannerObj.length - 1)) {
            bannerIndex++;
        } else { // Else reset index to 0.
            bannerIndex = 0;
        }

        // Update the banner
        SelectBanner();
    }

    // Cycle Banner Down.
    function CycleBannerDown() {
        // Hide current marker
        HideSelectedMarker();

        // Check if there is another banner in queue (downward).
        if (bannerIndex > 0) {
            bannerIndex--;
        } else { // Else reset index to json length.
            bannerIndex = (BannerObj.length - 1);
        }

        // Update the banner
        SelectBanner();
    }

    // Show Selected Marker.
    function ShowSelectedMarker() {
        var selectedMarker = "#banner-index-marker-" + bannerIndex;
        $(selectedMarker).addClass("selected");
    }

    // Hide Selected Marker.
    function HideSelectedMarker() {
        var selectedMarker = "#banner-index-marker-" + bannerIndex;
        $(selectedMarker).removeClass("selected");
    }

    // Stop the old timer if needed, and start a new one
    function ResetBannerTimer() {
        // Autoscroll banners.
        if (bannerTimer)
            window.clearInterval(bannerTimer);

        bannerTimer = window.setInterval(CycleBannerUp, 10000);
    }

    // Have initial button selected
    ShowSelectedMarker();

    // Start the timer
    ResetBannerTimer();

});
