/**
 * Created by Steven H Johnson - June 23, 2016
 *
 * Sets TAB and SHIFT + TAB keys to Indent and OutDent respectively.
 */
CKEDITOR.plugins.add('tabindent', {
    requires: 'indent',
    init: function(editor) {
        editor.on('key', function(ev) {
            // keyCode 9 = TAB
            if (ev.data.keyCode == 9 && editor.execCommand('indent') ||
                ev.data.keyCode == (CKEDITOR.SHIFT + 9) && editor.execCommand('outdent')) {
                ev.cancel();
            }
        });
    }
});
