CKEDITOR.plugins.add('nodelink', {
    icons: 'nodelink',
    init: function(editor) {
        if (typeof nodeItems !== 'undefined') {
            editor.addCommand('nodelink', new CKEDITOR.dialogCommand('nodelinkDialog', {
                allowedContent: 'a[data-node,href]',
                requiredContent: 'a[data-node,href]'
            }));
            CKEDITOR.dialog.add('nodelinkDialog', this.path + 'dialogs/nodelink.js');
            editor.ui.addButton('NodeLink', {
                label: 'Node Link',
                command: 'nodelink',
                toolbar: 'insert'
            });

            if (editor.contextMenu) {
                editor.addMenuGroup('nodelinkGroup');
                editor.addMenuItem('nodelinkItem', {
                    label: 'Edit Node Link',
                    icon: this.path + 'icons/nodelink.png',
                    command: 'nodelink',
                    group: 'nodelinkGroup'
                });

                editor.contextMenu.addListener(function(element) {
                    if (element.getAscendant('a', true)) {
                        return {
                            nodelinkItem: CKEDITOR.TRISTATE_OFF
                        };
                    }
                });
            }
        }
    }
});
