CKEDITOR.dialog.add('nodelinkDialog', function (editor) {
    return {
        title: 'Node Link Properties',
        minWidth: 400,
        minHeight: 200,

        contents: [
            {
                id: 'tab-basic',
                label: 'Basic Settings',
                elements: [
                    // UI elements of the first tab
                    {
                        type: 'select',
                        id: 'node',
                        label: 'Node',
                        items: nodeItems,
                        'default': nodeItems[0][0],
                        validate: CKEDITOR.dialog.validate.notEmpty("Field can not be empty."),
                        setup: function(element) {
                            this.setValue(element.getAttribute('data-node'));
                        },
                        commit: function(element) {
                            var value = this.getValue();
                            element.removeAttribute('data-cke-saved-href');
                            element.setAttribute('href', '{{ NODE:' + value + ' }}');
                            element.setAttribute('data-node', value);
                        }
                    },
                    {
                        type: 'text',
                        id: 'text',
                        label: 'text',
                        validate: CKEDITOR.dialog.validate.notEmpty("Field can not be empty."),
                        setup: function(element) {
                            this.setValue(element.getText());
                        },
                        commit: function(element) {
                            element.setText(this.getValue());
                        }
                    }
                ]
            }
        ],
        onShow: function() {
            var selection = editor.getSelection();
            var element = selection.getStartElement();

            if (element)
                element = element.getAscendant('a', true);

            if (!element || element.getName() != 'a') {
                element = editor.document.createElement('a');
                element.setText(selection.getSelectedText());
                this.insertMode = true;
            } else {
                this.insertMode = false;
            }

            this.element = element;

            this.setupContent(element);
        },
        onOk: function() {
            var dialog = this;
            var anchor = dialog.element;

            dialog.commitContent(anchor);

            if (dialog.insertMode)
                editor.insertElement(anchor);
        }
    };
});
