"""views.py"""
from django.shortcuts import render
from django.template import RequestContext

from sponsors.models import Company, Individual
from usta.models import get_site_settings


def view_sponsors(request):
    """Dev function to list companies"""
    sponsors_1 = Company.objects.filter(
        sponsor_level=Company.LEVEL_SPONSOR_TITLE_EXHIBITION)
    sponsors_2 = Company.objects.filter(
        sponsor_level=Company.LEVEL_SPONSOR_SPECIAL_EVENT)
    sponsors_3 = Company.objects.filter(
        sponsor_level=Company.LEVEL_SPONSOR_DISTINGUISHED)
    patrons_1 = Company.objects.filter(
        sponsor_level=Company.LEVEL_CORP_PATRON_DISTINGUISHED)
    patrons_2 = Company.objects.filter(
        sponsor_level=Company.LEVEL_CORP_PATRON_STANDARD)
    advertisers = Company.objects.filter(advertiser=True)
    individuals = Individual.objects.all()

    site_settings = get_site_settings()

    individual_patrons = site_settings.get_setting(
        'individual_patrons_document', None)

    return render(request, 'sponsors/view_sponsors.html', {
        'sponsors_1': sponsors_1,
        'sponsors_2': sponsors_2,
        'sponsors_3': sponsors_3,
        'patrons_1': patrons_1,
        'patrons_2': patrons_2,
        'advertisers': advertisers,
        'individuals': individuals,
        'individual_patrons': individual_patrons,
        'title': 'Sponsors',
        'show_generic': True,
    })
