# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(unique=True, max_length=100)),
                ('image', models.ImageField(blank=True, upload_to='companies/')),
                ('link', models.URLField(blank=True)),
                ('sponsor_level', models.PositiveSmallIntegerField(choices=[(0, 'None'), (1, 'Title & Exhibition Sponsor'), (2, 'Special Event Sponsor'), (3, 'Distinguished Sponsor'), (4, 'Distinguished Corporate Patron'), (5, 'Standard Corporate Patron')], default=0)),
                ('advertiser', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['name'],
                'verbose_name_plural': 'companies',
            },
        ),
        migrations.CreateModel(
            name='Individual',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100)),
            ],
        ),
    ]
