"""admin.py"""
from django.contrib import admin

from sponsors.models import Company, Individual


class CompanyAdmin(admin.ModelAdmin):
    """Simple Company Admin"""
    model = Company
    list_display = ('name', 'admin_image', 'advertiser', 'sponsor_level')
    list_filter = ['advertiser', 'sponsor_level']
    search_fields = ['name']


class IndividualAdmin(admin.ModelAdmin):
    """Simple Individual Admin"""
    model = Individual
    list_display = ('name',)
    search_fields = ['name']
